/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.rest;

import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.dlp.rest.DlpItemRestServices;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.dlp.utils.DlpUtils;
import org.exoplatform.portal.config.UserACL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpItemRestServicesTest {
    private static final MockedStatic<DlpUtils> DLP_UTILS = Mockito.mockStatic(DlpUtils.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    @Mock
    private DlpPositiveItemService dlpPositiveItemService;
    @Mock
    private DlpOperationProcessor dlpOperationProcessor;
    @Mock
    private UserACL userACL;
    private DlpItemRestServices dlpItemRestServices;
    private static final String DLP_GROUP = "/platform/dlp";

    @AfterClass
    public static void afterRunBare() throws Exception {
        DLP_UTILS.close();
        COMMONS_UTILS.close();
    }

    @Before
    public void setUp() {
        this.dlpItemRestServices = new DlpItemRestServices(this.dlpPositiveItemService, this.dlpOperationProcessor);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(UserACL.class)).thenReturn((Object)this.userACL);
        Mockito.when((Object)this.userACL.isUserInGroup(DLP_GROUP)).thenReturn((Object)true);
    }

    @Test
    public void getDlpPositiveItems() throws Exception {
        ArrayList<DlpPositiveItem> dlpPositiveItems = new ArrayList<DlpPositiveItem>();
        DlpPositiveItem dlpPositiveItem = new DlpPositiveItem();
        dlpPositiveItem.setId(Long.valueOf(1L));
        dlpPositiveItem.setKeywords("test");
        dlpPositiveItem.setTitle("title");
        dlpPositiveItems.add(dlpPositiveItem);
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenReturn((Object)false);
        Response response = this.dlpItemRestServices.getDlpPositiveItems(0, 10);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenCallRealMethod();
        Mockito.when((Object)this.dlpPositiveItemService.getDlpPositivesItems(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(dlpPositiveItems);
        Mockito.when((Object)this.dlpPositiveItemService.getDlpPositiveItemsCount()).thenReturn((Object)dlpPositiveItems.size());
        Response response1 = this.dlpItemRestServices.getDlpPositiveItems(0, 10);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((DlpPositiveItemService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.dlpPositiveItemService)).getDlpPositivesItems(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Response response2 = this.dlpItemRestServices.getDlpPositiveItems(0, 10);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response2.getStatus());
    }

    @Test
    public void deleteDlpDocumentById() throws Exception {
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenReturn((Object)false);
        Response response = this.dlpItemRestServices.deleteDlpDocumentById(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenCallRealMethod();
        Response response1 = this.dlpItemRestServices.deleteDlpDocumentById(Long.valueOf(1L));
        ((DlpPositiveItemService)Mockito.verify((Object)this.dlpPositiveItemService, (VerificationMode)Mockito.times((int)1))).deleteDlpPositiveItem(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
    }

    @Test
    public void getDlpKeywords() throws Exception {
        String keywords = "test, anything";
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenReturn((Object)false);
        Response response = this.dlpItemRestServices.getDlpKeywords();
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenCallRealMethod();
        Mockito.when((Object)this.dlpOperationProcessor.getKeywords()).thenReturn((Object)keywords);
        Response response1 = this.dlpItemRestServices.getDlpKeywords();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((DlpOperationProcessor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.dlpOperationProcessor)).getKeywords();
        Response response2 = this.dlpItemRestServices.getDlpKeywords();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response2.getStatus());
    }

    @Test
    public void setDlpKeywords() throws Exception {
        String keywords = "test, anything";
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenReturn((Object)false);
        Response response = this.dlpItemRestServices.setDlpKeywords(keywords);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenCallRealMethod();
        Response response1 = this.dlpItemRestServices.setDlpKeywords(keywords);
        ((DlpOperationProcessor)Mockito.verify((Object)this.dlpOperationProcessor, (VerificationMode)Mockito.times((int)1))).setKeywords(keywords);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((DlpOperationProcessor)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.dlpOperationProcessor)).setKeywords(keywords);
        Response response2 = this.dlpItemRestServices.setDlpKeywords(keywords);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response2.getStatus());
    }

    @Test
    public void restoreDlpPositiveItems() throws Exception {
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenReturn((Object)false);
        Response response = this.dlpItemRestServices.restoreDlpPositiveItems(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        DLP_UTILS.when(() -> DlpUtils.isDlpAdmin()).thenCallRealMethod();
        Response response1 = this.dlpItemRestServices.restoreDlpPositiveItems(Long.valueOf(1L));
        ((DlpPositiveItemService)Mockito.verify((Object)this.dlpPositiveItemService, (VerificationMode)Mockito.times((int)1))).restoreDlpPositiveItem(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((DlpPositiveItemService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.dlpPositiveItemService)).restoreDlpPositiveItem(Long.valueOf(1L));
        Response response2 = this.dlpItemRestServices.restoreDlpPositiveItems(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response2.getStatus());
    }
}

