/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.dlp.connector.DlpServiceConnector;
import org.exoplatform.dlp.dao.DlpOperationDAO;
import org.exoplatform.dlp.domain.DlpOperation;
import org.exoplatform.dlp.processor.impl.DlpOperationProcessorImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpOperationProcessorTest {
    private DlpOperationProcessorImpl dlpOperationProcessor;
    @Mock
    private DlpOperationDAO dlpOperationDAO;
    @Mock
    private DlpServiceConnector dlpFileServiceConnector;
    @Mock
    private DlpServiceConnector dlpActivityServiceConnector;

    @Before
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
        PortalContainer.getInstance();
        this.initDlpServiceConnector();
        this.dlpOperationProcessor = new DlpOperationProcessorImpl(this.dlpOperationDAO);
    }

    private void initDlpServiceConnector() {
        Mockito.when((Object)this.dlpFileServiceConnector.getType()).thenReturn((Object)"file");
        Mockito.lenient().when((Object)this.dlpFileServiceConnector.getDisplayName()).thenReturn((Object)"file");
        Mockito.lenient().when((Object)this.dlpFileServiceConnector.isEnable()).thenReturn((Object)true);
        Mockito.when((Object)this.dlpActivityServiceConnector.getType()).thenReturn((Object)"activity");
        Mockito.lenient().when((Object)this.dlpActivityServiceConnector.getDisplayName()).thenReturn((Object)"activity");
        Mockito.lenient().when((Object)this.dlpActivityServiceConnector.isEnable()).thenReturn((Object)true);
    }

    @After
    public void clean() {
        this.dlpOperationProcessor.getConnectors().clear();
    }

    @Test
    public void testAddConnector() {
        Assert.assertEquals((long)0L, (long)this.dlpOperationProcessor.getConnectors().size());
        this.dlpOperationProcessor.addConnector(this.dlpFileServiceConnector);
        Assert.assertEquals((long)1L, (long)this.dlpOperationProcessor.getConnectors().size());
    }

    @Test
    public void testProcess() {
        this.dlpOperationProcessor.start();
        this.dlpOperationProcessor.addConnector(this.dlpFileServiceConnector);
        this.dlpOperationProcessor.addConnector(this.dlpActivityServiceConnector);
        Mockito.when((Object)this.dlpOperationDAO.findAllFirstWithOffset(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn(this.getDlpOperations());
        Mockito.when((Object)this.dlpOperationDAO.count()).thenReturn((Object)this.getDlpOperations().size()).thenReturn((Object)0L);
        Mockito.when((Object)this.dlpFileServiceConnector.processItem(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.dlpActivityServiceConnector.processItem(ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.dlpOperationProcessor.process();
        ((DlpOperationDAO)Mockito.verify((Object)this.dlpOperationDAO, (VerificationMode)Mockito.times((int)3))).delete((Object)((DlpOperation)ArgumentMatchers.any()));
    }

    private List<DlpOperation> getDlpOperations() {
        ArrayList<DlpOperation> dlpOperations = new ArrayList<DlpOperation>();
        DlpOperation dlpOperation = new DlpOperation();
        dlpOperation.setId(Long.valueOf(1L));
        dlpOperation.setEntityType("file");
        dlpOperation.setEntityId("1");
        dlpOperations.add(dlpOperation);
        dlpOperation = new DlpOperation();
        dlpOperation.setId(Long.valueOf(2L));
        dlpOperation.setEntityType("file");
        dlpOperation.setEntityId("22");
        dlpOperations.add(dlpOperation);
        dlpOperation = new DlpOperation();
        dlpOperation.setId(Long.valueOf(3L));
        dlpOperation.setEntityType("activity");
        dlpOperation.setEntityId("100");
        dlpOperations.add(dlpOperation);
        return dlpOperations;
    }

    private List<DlpOperation> getDlpOperations(int size) {
        ArrayList<DlpOperation> dlpOperations = new ArrayList<DlpOperation>();
        for (int i = 1; i <= size; ++i) {
            DlpOperation dlpOperation = new DlpOperation();
            dlpOperation.setId(new Long(i));
            dlpOperation.setEntityType("file");
            dlpOperation.setEntityId("" + i);
            dlpOperations.add(dlpOperation);
        }
        return dlpOperations;
    }

    @Test
    public void testProcessWhenmoreItemsThanBatchStayInQueue() throws Exception {
        this.dlpOperationProcessor.start();
        this.dlpOperationProcessor.addConnector(this.dlpFileServiceConnector);
        this.dlpOperationProcessor.setBatchNumber(Integer.valueOf(15));
        List<DlpOperation> dlpOperations = this.getDlpOperations(this.dlpOperationProcessor.getBatchNumber() + 10);
        Mockito.when((Object)this.dlpOperationDAO.findAllFirstWithOffset(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenAnswer(invocation -> {
            int offset = (Integer)invocation.getArgument(0, Integer.class);
            int limit = (Integer)invocation.getArgument(1, Integer.class);
            return dlpOperations.stream().skip(offset).limit(limit).collect(Collectors.toList());
        });
        Mockito.when((Object)this.dlpOperationDAO.count()).thenReturn((Object)dlpOperations.size());
        Mockito.when((Object)this.dlpFileServiceConnector.processItem(ArgumentMatchers.anyString())).thenReturn((Object)false);
        this.dlpOperationProcessor.process();
        ((DlpOperationDAO)Mockito.verify((Object)this.dlpOperationDAO, (VerificationMode)Mockito.times((int)3))).count();
    }
}

