/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.dlp.connector.DlpServiceConnector;
import org.exoplatform.dlp.dao.DlpPositiveItemDAO;
import org.exoplatform.dlp.domain.DlpPositiveItemEntity;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.processor.DlpOperationProcessor;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class DlpPositiveItemServiceImpl
implements DlpPositiveItemService {
    private static final Log LOG = ExoLogger.getLogger(DlpPositiveItemServiceImpl.class);
    private final DlpPositiveItemDAO dlpPositiveItemDAO;
    private DlpOperationProcessor dlpOperationProcessor;
    private ListenerService listenerService;
    private OrganizationService organizationService;

    public DlpPositiveItemServiceImpl(DlpPositiveItemDAO dlpPositiveItemDAO, OrganizationService organizationService, ListenerService listenerService, DlpOperationProcessor dlpOperationProcessor) {
        this.dlpPositiveItemDAO = dlpPositiveItemDAO;
        this.organizationService = organizationService;
        this.listenerService = listenerService;
        this.dlpOperationProcessor = dlpOperationProcessor;
    }

    public DlpPositiveItem getDlpPositiveItemById(Long itemId) throws Exception {
        DlpPositiveItemEntity itemEntity = (DlpPositiveItemEntity)this.dlpPositiveItemDAO.find((Serializable)itemId);
        return itemEntity != null ? this.fillDlpPositiveItemFromEntity(itemEntity) : null;
    }

    public List<DlpPositiveItem> getDlpPositivesItems(int offset, int limit) throws Exception {
        List dlpPositiveItemEntities = this.dlpPositiveItemDAO.getDlpPositiveItems(offset, limit);
        return this.fillDlpPositiveItemsFromEntities(dlpPositiveItemEntities);
    }

    public void addDlpPositiveItem(DlpPositiveItemEntity dlpPositiveItemEntity) {
        this.dlpPositiveItemDAO.create((Object)dlpPositiveItemEntity);
        try {
            this.listenerService.broadcast(new Event("dlp.listener.event.detect.item", null, (Object)dlpPositiveItemEntity.getId()));
        }
        catch (Exception e) {
            LOG.error((Object)"Error when broadcasting dlp detect positive item", (Throwable)e);
        }
    }

    public void deleteDlpPositiveItem(Long itemId) {
        DlpPositiveItemEntity dlpPositiveItemEntity = (DlpPositiveItemEntity)this.dlpPositiveItemDAO.find((Serializable)itemId);
        if (dlpPositiveItemEntity != null) {
            long startTime = System.currentTimeMillis();
            this.dlpPositiveItemDAO.delete((Object)dlpPositiveItemEntity);
            try {
                this.listenerService.broadcast(new Event("dlp.listener.event.delete.item", null, (Object)dlpPositiveItemEntity.getReference()));
            }
            catch (Exception e) {
                LOG.error((Object)"Error when broadcasting delete file event", (Throwable)e);
            }
            long endTime = System.currentTimeMillis();
            long totalTime = endTime - startTime;
            LOG.info("service={} operation={} parameters=\"fileName:{}\" status=ok duration_ms={}", new Object[]{"dlp", "dlpPositiveItemDeletion", dlpPositiveItemEntity.getTitle(), totalTime});
        } else {
            LOG.warn("The DlpItem's {} not found.", new Object[]{itemId});
        }
    }

    public DlpPositiveItem getDlpPositiveItemByReference(String itemReference) throws Exception {
        DlpPositiveItemEntity dlpPositiveItemEntity = this.dlpPositiveItemDAO.findDlpPositiveItemByReference(itemReference);
        return this.fillDlpPositiveItemFromEntity(dlpPositiveItemEntity);
    }

    public Long getDlpPositiveItemsCount() {
        return this.dlpPositiveItemDAO.count();
    }

    private List<DlpPositiveItem> fillDlpPositiveItemsFromEntities(List<DlpPositiveItemEntity> dlpPositiveItemEntities) throws Exception {
        ArrayList<DlpPositiveItem> dlpPositiveItems = new ArrayList<DlpPositiveItem>();
        for (DlpPositiveItemEntity dlpPositiveItemEntity : dlpPositiveItemEntities) {
            DlpPositiveItem dlpPositiveItem = this.fillDlpPositiveItemFromEntity(dlpPositiveItemEntity);
            dlpPositiveItems.add(dlpPositiveItem);
        }
        return dlpPositiveItems;
    }

    public void restoreDlpPositiveItem(Long itemId) {
        try {
            DlpPositiveItemEntity dlpPositiveItemEntity = (DlpPositiveItemEntity)this.dlpPositiveItemDAO.find((Serializable)itemId);
            if (dlpPositiveItemEntity != null) {
                this.dlpPositiveItemDAO.delete((Object)dlpPositiveItemEntity);
                this.listenerService.broadcast(new Event("dlp.listener.event.restore.item", null, (Object)dlpPositiveItemEntity));
            } else {
                LOG.warn("The DlpItem's {} not found.", new Object[]{itemId});
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when broadcasting restore file event", (Throwable)e);
        }
    }

    private DlpPositiveItem fillDlpPositiveItemFromEntity(DlpPositiveItemEntity dlpPositiveItemEntity) throws Exception {
        DlpPositiveItem dlpPositiveItem = new DlpPositiveItem();
        DlpServiceConnector dlpServiceConnector = this.dlpOperationProcessor.getConnectors().get(dlpPositiveItemEntity.getType());
        dlpPositiveItem.setId(dlpPositiveItemEntity.getId());
        dlpPositiveItem.setType(dlpPositiveItemEntity.getType());
        dlpPositiveItem.setKeywords(dlpPositiveItemEntity.getKeywords());
        dlpPositiveItem.setAuthor(dlpPositiveItemEntity.getAuthor());
        dlpPositiveItem.setReference(dlpPositiveItemEntity.getReference());
        User user = this.organizationService.getUserHandler().findUserByName(dlpPositiveItemEntity.getAuthor());
        if (user != null) {
            dlpPositiveItem.setAuthorDisplayName(user.getDisplayName());
            dlpPositiveItem.setExternal(dlpServiceConnector != null && dlpServiceConnector.checkExternal(dlpPositiveItemEntity.getAuthor()));
        }
        dlpPositiveItem.setTitle(dlpPositiveItemEntity.getTitle());
        dlpPositiveItem.setItemUrl(dlpServiceConnector != null ? dlpServiceConnector.getItemUrl(dlpPositiveItemEntity.getReference()) : "");
        dlpPositiveItem.setDetectionDate(Long.valueOf(dlpPositiveItemEntity.getDetectionDate().getTimeInMillis()));
        return dlpPositiveItem;
    }
}

