/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.plugin;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.dto.DlpPositiveItem;
import org.exoplatform.dlp.notification.plugin.DlpAdminDetectedItemPlugin;
import org.exoplatform.dlp.service.DlpPositiveItemService;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpAdminDetectedItemPluginTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    @Mock
    private InitParams initParams;
    @Mock
    private DlpPositiveItemService dlpPositiveItemService;
    @Mock
    private OrganizationService organizationService;
    private DlpAdminDetectedItemPlugin dlpAdminDetectedItemPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.dlpAdminDetectedItemPlugin = new DlpAdminDetectedItemPlugin(this.initParams, this.dlpPositiveItemService, this.organizationService);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
    }

    @Test
    public void makeNotification() throws Exception {
        DlpPositiveItem dlpPositiveItem = new DlpPositiveItem();
        dlpPositiveItem.setAuthor("author");
        dlpPositiveItem.setTitle("file.docx");
        dlpPositiveItem.setAuthorDisplayName("user author");
        Mockito.when((Object)this.dlpPositiveItemService.getDlpPositiveItemById(Long.valueOf(1L))).thenReturn((Object)dlpPositiveItem);
        UserHandler userHandler = (UserHandler)Mockito.mock(UserHandler.class);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)userHandler);
        ListAccess dlpMembersAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)dlpMembersAccess.getSize()).thenReturn((Object)1);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getUserName()).thenReturn((Object)"userName");
        Mockito.when((Object)userHandler.findUsersByGroupId("/platform/dlp")).thenReturn((Object)dlpMembersAccess);
        User[] usersArray = new User[]{user};
        Mockito.when((Object)((User[])dlpMembersAccess.load(0, dlpMembersAccess.getSize()))).thenReturn((Object)usersArray);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(new ArgumentLiteral(Long.class, "dlp_detected_item_id"), (Object)1L);
        NotificationInfo notificationInfo = this.dlpAdminDetectedItemPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"file.docx", (Object)notificationInfo.getValueOwnerParameter("itemTitle"));
        Assert.assertEquals(List.of("userName"), (Object)notificationInfo.getSendToUserIds());
    }
}

