/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.notification.plugin;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.dlp.notification.plugin.DlpUserRestoredItemPlugin;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DlpUserRestoredItemPluginTest {
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    @Mock
    private InitParams initParams;
    private DlpUserRestoredItemPlugin dlpUserRestoredItemPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.dlpUserRestoredItemPlugin = new DlpUserRestoredItemPlugin(this.initParams);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
    }

    @Test
    public void makeNotification() {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(new ArgumentLiteral(String.class, "dlp_restored_item_reference"), (Object)"1");
        ctx.append(new ArgumentLiteral(String.class, "dlp_restored_item_author"), (Object)"author");
        ctx.append(new ArgumentLiteral(String.class, "dlp_restored_item_title"), (Object)"file.docx");
        NotificationInfo notificationInfo = this.dlpUserRestoredItemPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"file.docx", (Object)notificationInfo.getValueOwnerParameter("itemTitle"));
        Assert.assertEquals((Object)"1", (Object)notificationInfo.getValueOwnerParameter("itemReference"));
        Assert.assertEquals((Object)"author", (Object)notificationInfo.getTo());
    }
}

