/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.dlp.dao;

import java.util.Calendar;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.dlp.dao.RestoredDlpItemDAO;
import org.exoplatform.dlp.domain.RestoredDlpItemEntity;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RestoredDlpItemDAOTest {
    private RestoredDlpItemDAO restoredDlpItemDAO;

    @Before
    public void setUp() {
        PortalContainer container = PortalContainer.getInstance();
        this.restoredDlpItemDAO = (RestoredDlpItemDAO)container.getComponentInstanceOfType(RestoredDlpItemDAO.class);
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        this.restoredDlpItemDAO.deleteAll();
    }

    @After
    public void tearDown() {
        this.restoredDlpItemDAO.deleteAll();
        RequestLifeCycle.end();
    }

    @Test
    public void testDeleteDlpPositiveItemByReference() {
        RestoredDlpItemEntity restoredDlpItemEntity = new RestoredDlpItemEntity();
        restoredDlpItemEntity.setReference("nodeUID1");
        restoredDlpItemEntity.setDetectionDate(Calendar.getInstance());
        this.restoredDlpItemDAO.create((Object)restoredDlpItemEntity);
        Assert.assertEquals((long)1L, (long)this.restoredDlpItemDAO.count().intValue());
        this.restoredDlpItemDAO.delete((Object)restoredDlpItemEntity);
        Assert.assertEquals((long)0L, (long)this.restoredDlpItemDAO.count().intValue());
    }

    @Test
    public void testFindRestoredDlpItemByReference() {
        Assert.assertEquals((long)0L, (long)this.restoredDlpItemDAO.findAll().size());
        Assert.assertEquals(null, (Object)this.restoredDlpItemDAO.findRestoredDlpItemByReference("001002003"));
        RestoredDlpItemEntity restoredDlpItemEntity = new RestoredDlpItemEntity();
        restoredDlpItemEntity.setReference("001002003");
        restoredDlpItemEntity.setDetectionDate(Calendar.getInstance());
        this.restoredDlpItemDAO.create((Object)restoredDlpItemEntity);
        Assert.assertNotNull((Object)this.restoredDlpItemDAO.findRestoredDlpItemByReference("001002003"));
    }
}

