/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.es.client;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.exoplatform.addons.es.client.ElasticClient;
import org.exoplatform.addons.es.client.ElasticClientException;
import org.exoplatform.addons.es.client.ElasticIndexingAuditTrail;
import org.exoplatform.addons.es.client.ElasticResponse;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;

public class ElasticIndexingClient
extends ElasticClient {
    public static final String EMPTY_JSON = "{}";
    private static final Log LOG = ExoLogger.getExoLogger(ElasticIndexingClient.class);
    private static final String ES_INDEX_CLIENT_PROPERTY_NAME = "exo.es.index.server.url";
    private static final String ES_INDEX_CLIENT_PROPERTY_USERNAME = "exo.es.index.server.username";
    private static final String ES_INDEX_CLIENT_PROPERTY_PASSWORD = "exo.es.index.server.password";
    private ElasticIndexingAuditTrail auditTrail;

    public ElasticIndexingClient(ElasticIndexingAuditTrail auditTrail) {
        super(auditTrail);
        if (auditTrail == null) {
            throw new IllegalArgumentException("AuditTrail is null");
        }
        this.auditTrail = auditTrail;
        if (StringUtils.isNotBlank((String)PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_NAME))) {
            this.urlClient = PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_NAME);
            LOG.info("Using {} as Indexing URL", new Object[]{this.urlClient});
        } else {
            LOG.info((Object)"Using default as Indexing URL");
        }
    }

    public void sendCreateIndexRequest(String index, String settings) {
        String url = this.urlClient + "/" + index;
        ElasticResponse responseExists = this.sendHttpGetRequest(url);
        if (responseExists.getStatusCode() == 200) {
            LOG.info("Index {} already exists. Index creation requests will not be sent.", new Object[]{index});
        } else if (responseExists.getStatusCode() == 404) {
            LOG.info("Index {} doesn't exist. Index creation requests will be sent.", new Object[]{index});
            long startTime = System.currentTimeMillis();
            ElasticResponse responseCreate = this.sendHttpPostRequest(url, settings);
            this.auditTrail.audit("create_index", null, index, null, responseCreate.getStatusCode(), responseCreate.getMessage(), System.currentTimeMillis() - startTime);
        } else {
            LOG.error("Index exists: Unsupported HttpStatusCode {}. url={}", new Object[]{responseExists.getStatusCode(), url});
        }
    }

    public void sendCreateTypeRequest(String index, String type, String mappings) {
        String url = this.urlClient + "/" + index + "/_mapping/" + type;
        ElasticResponse responseExists = this.sendHttpGetRequest(url);
        if (responseExists.getStatusCode() == 200) {
            if (EMPTY_JSON.equals(responseExists.getMessage())) {
                LOG.info("Mapping doesn't exist for type {}. Mapping creation requests will be sent.", new Object[]{type});
                long startTime = System.currentTimeMillis();
                ElasticResponse response = this.sendHttpPostRequest(url, mappings);
                this.auditTrail.audit("create_type", null, index, type, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
            } else {
                LOG.info("Mapping already exists for type {}. Mapping creation requests will not be sent.", new Object[]{type});
            }
        } else {
            LOG.error("Mapping exists: Unsupported HttpStatusCode {}. url={}", new Object[]{responseExists.getStatusCode(), url});
        }
    }

    public void sendDeleteTypeRequest(String index, String type) {
        long startTime = System.currentTimeMillis();
        ElasticResponse response = this.sendHttpDeleteRequest(this.urlClient + "/" + index + "/" + type);
        this.auditTrail.audit("delete_type", null, index, type, response.getStatusCode(), response.getMessage(), System.currentTimeMillis() - startTime);
    }

    public void sendCUDRequest(String bulkRequest) {
        long startTime = System.currentTimeMillis();
        ElasticResponse response = this.sendHttpPostRequest(this.urlClient + "/_bulk", bulkRequest);
        this.logBulkResponse(response.getMessage(), System.currentTimeMillis() - startTime);
    }

    private void logBulkResponse(String response, long executionTime) {
        try {
            Object parsedResponse = JSONValue.parseWithException((String)response);
            if (!(parsedResponse instanceof JSONObject)) {
                LOG.error("Unable to parse Bulk response: response is not a JSON. response={}", new Object[]{response});
                throw new ElasticClientException("Unable to parse Bulk response: response is not a JSON.");
            }
            Object items = ((JSONObject)parsedResponse).get((Object)"items");
            if (items != null) {
                if (!(items instanceof JSONArray)) {
                    LOG.error("Unable to parse Bulk response: items is not a JSONArray. items={}", new Object[]{items});
                    throw new ElasticClientException("Unable to parse Bulk response: items is not a JSONArray.");
                }
                for (Object item : ((JSONArray)items).toArray()) {
                    if (!(item instanceof JSONObject)) {
                        LOG.error("Unable to parse Bulk response: item is not a JSONObject. item={}", new Object[]{item});
                        throw new ElasticClientException("Unable to parse Bulk response: item is not a JSONObject.");
                    }
                    this.logBulkResponseItem((JSONObject)item, executionTime);
                }
            }
        }
        catch (ParseException e) {
            throw new ElasticClientException("Unable to parse Bulk response", e);
        }
    }

    private void logBulkResponseItem(JSONObject item, long executionTime) {
        for (Map.Entry operation : item.entrySet()) {
            Integer httpStatusCode;
            String operationName;
            String string = operationName = operation.getKey() == null ? null : (String)operation.getKey();
            if (operation.getValue() == null) continue;
            JSONObject operationDetails = (JSONObject)operation.getValue();
            String index = operationDetails.get((Object)"_index") == null ? null : (String)operationDetails.get((Object)"_index");
            String type = operationDetails.get((Object)"_type") == null ? null : (String)operationDetails.get((Object)"_type");
            String id = operationDetails.get((Object)"_id") == null ? null : (String)operationDetails.get((Object)"_id");
            Long status = operationDetails.get((Object)"status") == null ? null : (Long)operationDetails.get((Object)"status");
            String error = operationDetails.get((Object)"error") == null ? null : (String)operationDetails.get((Object)"error");
            Integer n = httpStatusCode = status == null ? null : Integer.valueOf(status.intValue());
            if (ElasticIndexingAuditTrail.isError(httpStatusCode)) {
                this.auditTrail.logRejectedDocumentBulkOperation(operationName, id, index, type, httpStatusCode, error, executionTime);
                continue;
            }
            if (!this.auditTrail.isFullLogEnabled()) continue;
            this.auditTrail.logAcceptedBulkOperation(operationName, id, index, type, httpStatusCode, error, executionTime);
        }
    }

    @Override
    protected String getEsUsernameProperty() {
        return PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_USERNAME);
    }

    @Override
    protected String getEsPasswordProperty() {
        return PropertyManager.getProperty((String)ES_INDEX_CLIENT_PROPERTY_PASSWORD);
    }

    @Override
    protected ClientConnectionManager getClientConnectionManager() {
        return new SingleClientConnManager();
    }
}

