/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.es.rest;

import java.text.ParseException;
import java.util.ArrayList;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.addons.es.domain.IndexingOperation;
import org.exoplatform.addons.es.index.IndexingOperationProcessor;
import org.exoplatform.addons.es.index.IndexingService;
import org.exoplatform.addons.es.index.IndexingServiceConnector;
import org.exoplatform.addons.es.index.impl.QueueIndexingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/indexingManagement")
@Produces(value={"application/json"})
@RolesAllowed(value={"administrators"})
public class IndexingManagementRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(IndexingManagementRestService.class);
    private QueueIndexingService indexingService;
    private IndexingOperationProcessor indexingOperationProcessor;

    public IndexingManagementRestService(IndexingService indexingService, IndexingOperationProcessor indexingOperationProcessor) {
        this.indexingService = (QueueIndexingService)indexingService;
        this.indexingOperationProcessor = indexingOperationProcessor;
    }

    @GET
    @Path(value="/connector")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getConnectors() {
        ArrayList<IndexingServiceConnector> connectors = new ArrayList<IndexingServiceConnector>(this.indexingOperationProcessor.getConnectors().values());
        return Response.ok(connectors, (String)"application/json").build();
    }

    @GET
    @Path(value="/connector/{connectorType}/_reindex")
    @RolesAllowed(value={"administrators"})
    public Response reindexConnector(@PathParam(value="connectorType") String connectorType) {
        this.indexingService.reindexAll(connectorType);
        return Response.ok((Object)"ok", (String)"text/plain").build();
    }

    @GET
    @Path(value="/connector/{connectorType}/_disable")
    @RolesAllowed(value={"administrators"})
    public Response disable(@PathParam(value="connectorType") String connectorType) {
        return Response.ok((Object)"ok", (String)"text/plain").build();
    }

    @GET
    @Path(value="/connector/{connectorType}/_enable")
    @RolesAllowed(value={"administrators"})
    public Response enable(@PathParam(value="connectorType") String connectorType) {
        return Response.ok((Object)"ok", (String)"text/plain").build();
    }

    @GET
    @Path(value="/connector/_count")
    @RolesAllowed(value={"administrators"})
    public Response getNbConnectors() {
        return Response.ok((Object)String.valueOf(this.indexingOperationProcessor.getConnectors().size()), (String)"text/plain").build();
    }

    @GET
    @Path(value="/operation")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getOperations() throws ParseException {
        ArrayList<IndexingOperation> operations = new ArrayList<IndexingOperation>(this.indexingService.getOperations(0, 100));
        return Response.ok(operations, (String)"application/json").build();
    }

    @GET
    @Path(value="/operation/_count")
    @RolesAllowed(value={"administrators"})
    public Response getNbIndexingOperations() {
        return Response.ok((Object)String.valueOf(this.indexingService.getNumberOperations()), (String)"text/plain").build();
    }

    @GET
    @Path(value="/error")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response getErrors() {
        return Response.ok(null, (String)"application/json").build();
    }

    @GET
    @Path(value="/error/_count")
    @RolesAllowed(value={"administrators"})
    public Response getNbIndexingErrors() {
        return Response.ok((Object)"0", (String)"text/plain").build();
    }
}

