/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.FolderIdWrapperList;
import microsoft.exchange.webservices.data.GetRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceObjectType;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GetFolderRequestBase<TResponse extends ServiceResponse>
extends GetRequest<Folder, TResponse> {
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();

    protected GetFolderRequestBase(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getFolderIds().iterator(), "FolderIds");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolderIds().getCount();
    }

    @Override
    protected ServiceObjectType getServiceObjectType() {
        return ServiceObjectType.Folder;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        this.getFolderIds().writeToXml(writer, XmlNamespace.Messages, "FolderIds");
    }

    @Override
    protected String getXmlElementName() {
        return "GetFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetFolderResponseMessage";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }
}

