/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Mailbox;
import microsoft.exchange.webservices.data.ServiceId;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.WellKnownFolderName;

public final class FolderId
extends ServiceId {
    private WellKnownFolderName folderName;
    private Mailbox mailbox;

    protected FolderId() {
    }

    public FolderId(String uniqueId) throws Exception {
        super(uniqueId);
    }

    public FolderId(WellKnownFolderName folderName) {
        this.folderName = folderName;
    }

    public FolderId(WellKnownFolderName folderName, Mailbox mailbox) {
        this(folderName);
        this.mailbox = mailbox;
    }

    protected String getXmlElementName() {
        if (this.getFolderName() != null) {
            return "DistinguishedFolderId";
        }
        return "FolderId";
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        if (this.getFolderName() != null) {
            writer.writeAttributeValue("Id", this.getFolderName().toString().toLowerCase());
            if (this.mailbox != null) {
                try {
                    this.mailbox.writeToXml(writer, "Mailbox");
                }
                catch (Exception e) {
                    throw new ServiceXmlSerializationException(e.getMessage());
                }
            }
        } else {
            super.writeAttributesToXml(writer);
        }
    }

    protected void validate(ExchangeVersion version) throws ServiceVersionException {
        if (this.getFolderName() != null) {
            EwsUtilities.validateEnumVersionValue(this.getFolderName(), version);
        }
    }

    public WellKnownFolderName getFolderName() {
        return this.folderName;
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public static FolderId getFolderIdFromString(String uniqueId) throws Exception {
        return new FolderId(uniqueId);
    }

    public static FolderId getFolderIdFromWellKnownFolderName(WellKnownFolderName folderName) {
        return new FolderId(folderName);
    }

    protected boolean getIsValid() {
        if (this.folderName != null) {
            return this.mailbox == null || this.mailbox.isValid();
        }
        return super.isValid();
    }

    public boolean equals(Object obj) {
        if (obj == this || obj == null && this == null) {
            return true;
        }
        if (obj instanceof FolderId) {
            FolderId other = (FolderId)obj;
            if (this.folderName != null) {
                if (other.folderName != null && this.folderName.equals((Object)other.folderName)) {
                    if (this.mailbox != null) {
                        return this.mailbox.equals(other.mailbox);
                    }
                    if (other.mailbox == null) {
                        return true;
                    }
                }
            } else if (super.equals(other)) {
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int hashCode;
        if (this.folderName != null) {
            hashCode = this.folderName.hashCode();
            if (this.mailbox != null && this.mailbox.isValid()) {
                hashCode ^= this.mailbox.hashCode();
            }
        } else {
            hashCode = super.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        if (this.isValid()) {
            if (this.folderName != null) {
                if (this.mailbox != null && this.mailbox.isValid()) {
                    return String.format("%s,(%s)", new Object[]{this.folderName, this.mailbox.toString()});
                }
                return this.folderName.toString();
            }
            return super.toString();
        }
        return "";
    }
}

