/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.ListIterator;
import microsoft.exchange.webservices.data.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.Attachable;
import microsoft.exchange.webservices.data.AttachmentCollection;
import microsoft.exchange.webservices.data.ConflictResolutionMode;
import microsoft.exchange.webservices.data.ConversationId;
import microsoft.exchange.webservices.data.DeleteMode;
import microsoft.exchange.webservices.data.EffectiveRights;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ExtendedPropertyCollection;
import microsoft.exchange.webservices.data.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Importance;
import microsoft.exchange.webservices.data.InternetMessageHeaderCollection;
import microsoft.exchange.webservices.data.InvalidOperationException;
import microsoft.exchange.webservices.data.ItemAttachment;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.ItemSchema;
import microsoft.exchange.webservices.data.MessageBody;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.MimeContent;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ResponseActions;
import microsoft.exchange.webservices.data.SendCancellationsMode;
import microsoft.exchange.webservices.data.SendInvitationsMode;
import microsoft.exchange.webservices.data.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.Sensitivity;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UniqueBody;
import microsoft.exchange.webservices.data.WellKnownFolderName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Attachable
@ServiceObjectDefinition(xmlElementName="Item")
public class Item
extends ServiceObject {
    private ItemAttachment parentAttachment;

    protected Item(ExchangeService service) throws Exception {
        super(service);
    }

    protected Item(ItemAttachment parentAttachment) throws Exception {
        this(parentAttachment.getOwner().getService());
        EwsUtilities.EwsAssert(parentAttachment != null, "Item.ctor", "parentAttachment is null");
        this.parentAttachment = parentAttachment;
    }

    public static Item bind(ExchangeService service, ItemId id, PropertySet propertySet) throws Exception {
        return service.bindToItem(Item.class, id, propertySet);
    }

    public static Item bind(ExchangeService service, ItemId id) throws Exception {
        return Item.bind(service, id, PropertySet.getFirstClassProperties());
    }

    @Override
    protected ServiceObjectSchema getSchema() {
        return ItemSchema.getInstance();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected void throwIfThisIsAttachment() throws InvalidOperationException {
        if (this.isAttachment()) {
            throw new InvalidOperationException(Strings.OperationDoesNotSupportAttachments);
        }
    }

    @Override
    protected PropertyDefinition getIdPropertyDefinition() {
        return ItemSchema.Id;
    }

    @Override
    protected void internalLoad(PropertySet propertySet) throws Exception {
        this.throwIfThisIsNew();
        this.throwIfThisIsAttachment();
        ArrayList<Item> itemArry = new ArrayList<Item>();
        itemArry.add(this);
        this.getService().internalLoadPropertiesForItems(itemArry, propertySet, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected void internalDelete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) throws ServiceLocalException, Exception {
        this.throwIfThisIsNew();
        this.throwIfThisIsAttachment();
        if (sendCancellationsMode == null) {
            sendCancellationsMode = this.getDefaultSendCancellationsMode();
        }
        if (affectedTaskOccurrences == null) {
            affectedTaskOccurrences = this.getDefaultAffectedTaskOccurrences();
        }
        this.getService().deleteItem(this.getId(), deleteMode, sendCancellationsMode, affectedTaskOccurrences);
    }

    protected void internalCreate(FolderId parentFolderId, MessageDisposition messageDisposition, SendInvitationsMode sendInvitationsMode) throws Exception {
        this.throwIfThisIsNotNew();
        this.throwIfThisIsAttachment();
        if (this.isNew() || this.isDirty()) {
            this.getService().createItem(this, parentFolderId, messageDisposition, sendInvitationsMode != null ? sendInvitationsMode : this.getDefaultSendInvitationsMode());
            this.getAttachments().save();
        }
    }

    protected Item internalUpdate(FolderId parentFolderId, ConflictResolutionMode conflictResolutionMode, MessageDisposition messageDisposition, SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode) throws ServiceResponseException, Exception {
        this.throwIfThisIsNew();
        this.throwIfThisIsAttachment();
        Item returnedItem = null;
        if (this.isDirty() && this.getPropertyBag().getIsUpdateCallNecessary()) {
            returnedItem = this.getService().updateItem(this, parentFolderId, conflictResolutionMode, messageDisposition, sendInvitationsOrCancellationsMode != null ? sendInvitationsOrCancellationsMode : this.getDefaultSendInvitationsOrCancellationsMode());
        }
        if (this.hasUnprocessedAttachmentChanges()) {
            this.getAttachments().validate();
            this.getAttachments().save();
        }
        return returnedItem;
    }

    protected boolean hasUnprocessedAttachmentChanges() throws ServiceLocalException {
        return this.getAttachments().hasUnprocessedChanges();
    }

    protected ItemAttachment getParentAttachment() {
        return this.parentAttachment;
    }

    protected ItemId getRootItemId() throws ServiceLocalException {
        if (this.isAttachment()) {
            return this.getParentAttachment().getOwner().getRootItemId();
        }
        return this.getId();
    }

    public void delete(DeleteMode deleteMode) throws ServiceLocalException, Exception {
        this.internalDelete(deleteMode, null, null);
    }

    public void save(FolderId parentFolderId) throws Exception {
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        this.internalCreate(parentFolderId, MessageDisposition.SaveOnly, null);
    }

    public void save(WellKnownFolderName parentFolderName) throws Exception {
        this.internalCreate(new FolderId(parentFolderName), MessageDisposition.SaveOnly, null);
    }

    public void save() throws Exception {
        this.internalCreate(null, MessageDisposition.SaveOnly, null);
    }

    public void update(ConflictResolutionMode conflictResolutionMode) throws ServiceResponseException, Exception {
        this.internalUpdate(null, conflictResolutionMode, MessageDisposition.SaveOnly, null);
    }

    public Item copy(FolderId destinationFolderId) throws Exception {
        this.throwIfThisIsNew();
        this.throwIfThisIsAttachment();
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.getService().copyItem(this.getId(), destinationFolderId);
    }

    public Item copy(WellKnownFolderName destinationFolderName) throws Exception {
        return this.copy(new FolderId(destinationFolderName));
    }

    public Item move(FolderId destinationFolderId) throws Exception {
        this.throwIfThisIsNew();
        this.throwIfThisIsAttachment();
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return this.getService().moveItem(this.getId(), destinationFolderId);
    }

    public Item move(WellKnownFolderName destinationFolderName) throws Exception {
        return this.move(new FolderId(destinationFolderName));
    }

    public void setExtendedProperty(ExtendedPropertyDefinition extendedPropertyDefinition, Object value) throws Exception {
        this.getExtendedProperties().setExtendedProperty(extendedPropertyDefinition, value);
    }

    public boolean removeExtendedProperty(ExtendedPropertyDefinition extendedPropertyDefinition) throws Exception {
        return this.getExtendedProperties().removeExtendedProperty(extendedPropertyDefinition);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        this.getAttachments().validate();
    }

    @Override
    protected boolean getIsTimeZoneHeaderRequired(boolean isUpdateOperation) throws Exception {
        if (!isUpdateOperation && this.getService().getRequestedServerVersion().ordinal() >= ExchangeVersion.Exchange2010_SP2.ordinal()) {
            ListIterator items = this.getAttachments().getItems().listIterator();
            while (items.hasNext()) {
                ItemAttachment itemAttachment = (ItemAttachment)items.next();
                if (itemAttachment.getItem() == null || !itemAttachment.getItem().getIsTimeZoneHeaderRequired(false)) continue;
                return true;
            }
        }
        return super.getIsTimeZoneHeaderRequired(isUpdateOperation);
    }

    public boolean isAttachment() {
        return this.parentAttachment != null;
    }

    public boolean getIsNew() throws ServiceLocalException {
        if (this.isAttachment()) {
            return this.getParentAttachment().isNew();
        }
        return super.isNew();
    }

    @Override
    public ItemId getId() throws ServiceLocalException {
        return (ItemId)this.getPropertyBag().getObjectFromPropertyDefinition(this.getIdPropertyDefinition());
    }

    public MimeContent getMimeContent() throws ServiceLocalException {
        return (MimeContent)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.MimeContent);
    }

    public void setMimeContent(MimeContent value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.MimeContent, value);
    }

    public FolderId getParentFolderId() throws ServiceLocalException {
        return (FolderId)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.ParentFolderId);
    }

    public Sensitivity getSensitivity() throws ServiceLocalException {
        return (Sensitivity)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Sensitivity));
    }

    public void setSensitivity(Sensitivity value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Sensitivity, (Object)value);
    }

    public AttachmentCollection getAttachments() throws ServiceLocalException {
        return (AttachmentCollection)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Attachments);
    }

    public Date getDateTimeReceived() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.DateTimeReceived);
    }

    public int getSize() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Size);
    }

    public StringList getCategories() throws ServiceLocalException {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Categories);
    }

    public void setCategories(StringList value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Categories, value);
    }

    public String getCulture() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Culture);
    }

    public void setCulture(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Culture, value);
    }

    public Importance getImportance() throws ServiceLocalException {
        return (Importance)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Importance));
    }

    public void setImportance(Importance value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Importance, (Object)value);
    }

    public String getInReplyTo() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.InReplyTo);
    }

    public void setInReplyTo(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.InReplyTo, value);
    }

    public boolean getIsSubmitted() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.IsSubmitted);
    }

    public boolean getIsAssociated() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.IsAssociated);
    }

    public boolean getIsDraft() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.IsDraft);
    }

    public boolean getIsFromMe() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.IsFromMe);
    }

    public boolean getIsResend() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.IsResend);
    }

    public boolean getIsUnmodified() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.IsUnmodified);
    }

    public InternetMessageHeaderCollection getInternetMessageHeaders() throws ServiceLocalException {
        return (InternetMessageHeaderCollection)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.InternetMessageHeaders);
    }

    public Date getDateTimeSent() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.DateTimeSent);
    }

    public Date getDateTimeCreated() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.DateTimeCreated);
    }

    public EnumSet<ResponseActions> getAllowedResponseActions() throws ServiceLocalException {
        return (EnumSet)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.AllowedResponseActions);
    }

    public Date getReminderDueBy() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.ReminderDueBy);
    }

    public void setReminderDueBy(Date value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.ReminderDueBy, value);
    }

    public boolean getIsReminderSet() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.IsReminderSet);
    }

    public void setIsReminderSet(Boolean value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.IsReminderSet, value);
    }

    public int getReminderMinutesBeforeStart() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.ReminderMinutesBeforeStart);
    }

    public void setReminderMinutesBeforeStart(int value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.ReminderMinutesBeforeStart, value);
    }

    public String getDisplayCc() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.DisplayCc);
    }

    public String getDisplayTo() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.DisplayTo);
    }

    public boolean getHasAttachments() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.HasAttachments);
    }

    public MessageBody getBody() throws ServiceLocalException {
        return (MessageBody)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Body);
    }

    public void setBody(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Body, value);
    }

    public String getItemClass() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.ItemClass);
    }

    public void setItemClass(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.ItemClass, value);
    }

    protected void setSubject(String subject) throws Exception {
        this.setSubject((Object)subject);
    }

    public void setSubject(Object subject) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Subject, subject);
    }

    public String getSubject() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.Subject);
    }

    public String getWebClientReadFormQueryString() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.WebClientReadFormQueryString);
    }

    public String getWebClientEditFormQueryString() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.WebClientEditFormQueryString);
    }

    @Override
    public ExtendedPropertyCollection getExtendedProperties() throws ServiceLocalException {
        return (ExtendedPropertyCollection)this.getPropertyBag().getObjectFromPropertyDefinition(ServiceObjectSchema.extendedProperties);
    }

    public EnumSet<EffectiveRights> getEffectiveRights() throws ServiceLocalException {
        return (EnumSet)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.EffectiveRights);
    }

    public String getLastModifiedName() throws ServiceLocalException {
        return (String)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.LastModifiedName);
    }

    public Date getLastModifiedTime() throws ServiceLocalException {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.LastModifiedTime);
    }

    public ConversationId getConversationId() throws ServiceLocalException {
        return (ConversationId)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.ConversationId);
    }

    public UniqueBody getUniqueBody() throws ServiceLocalException {
        return (UniqueBody)this.getPropertyBag().getObjectFromPropertyDefinition(ItemSchema.UniqueBody);
    }

    protected AffectedTaskOccurrence getDefaultAffectedTaskOccurrences() {
        return null;
    }

    protected SendCancellationsMode getDefaultSendCancellationsMode() {
        return null;
    }

    protected SendInvitationsMode getDefaultSendInvitationsMode() {
        return null;
    }

    protected SendInvitationsOrCancellationsMode getDefaultSendInvitationsOrCancellationsMode() {
        return null;
    }
}

