/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EmailAddressCollection;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Importance;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.MobilePhone;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuleActions
extends ComplexProperty {
    private static final String MobileType = "MOBILE";
    private StringList assignCategories = new StringList();
    private FolderId copyToFolder;
    private boolean delete;
    private EmailAddressCollection forwardAsAttachmentToRecipients = new EmailAddressCollection("Address");
    private EmailAddressCollection forwardToRecipients = new EmailAddressCollection("Address");
    private Importance markImportance;
    private boolean markAsRead;
    private FolderId moveToFolder;
    private boolean permanentDelete;
    private EmailAddressCollection redirectToRecipients = new EmailAddressCollection("Address");
    private Collection<MobilePhone> sendSMSAlertToRecipients = new ArrayList<MobilePhone>();
    private ItemId serverReplyWithMessage;
    private boolean stopProcessingRules;

    protected RuleActions() {
    }

    public StringList getAssignCategories() {
        return this.assignCategories;
    }

    public FolderId getCopyToFolder() {
        return this.copyToFolder;
    }

    public void setCopyToFolder(FolderId value) {
        if (this.canSetFieldValue(this.copyToFolder, value)) {
            this.copyToFolder = value;
            this.changed();
        }
    }

    public boolean getDelete() {
        return this.delete;
    }

    public void setDelete(boolean value) {
        if (this.canSetFieldValue(this.delete, value)) {
            this.delete = value;
            this.changed();
        }
    }

    public EmailAddressCollection getForwardAsAttachmentToRecipients() {
        return this.forwardAsAttachmentToRecipients;
    }

    public EmailAddressCollection getForwardToRecipients() {
        return this.forwardToRecipients;
    }

    public Importance getMarkImportance() {
        return this.markImportance;
    }

    public void setMarkImportance(Importance value) {
        if (this.canSetFieldValue(this.markImportance, value)) {
            this.markImportance = value;
            this.changed();
        }
    }

    public boolean getMarkAsRead() {
        return this.markAsRead;
    }

    public void setMarkAsRead(boolean value) {
        if (this.canSetFieldValue(this.markAsRead, value)) {
            this.markAsRead = value;
            this.changed();
        }
    }

    public FolderId getMoveToFolder() {
        return this.moveToFolder;
    }

    public void setMoveToFolder(FolderId value) {
        if (this.canSetFieldValue(this.moveToFolder, value)) {
            this.moveToFolder = value;
            this.changed();
        }
    }

    public boolean getPermanentDelete() {
        return this.permanentDelete;
    }

    public void setPermanentDelete(boolean value) {
        if (this.canSetFieldValue(this.permanentDelete, value)) {
            this.permanentDelete = value;
            this.changed();
        }
    }

    public EmailAddressCollection getRedirectToRecipients() {
        return this.redirectToRecipients;
    }

    public Collection<MobilePhone> getSendSMSAlertToRecipients() {
        return this.sendSMSAlertToRecipients;
    }

    public ItemId getServerReplyWithMessage() {
        return this.serverReplyWithMessage;
    }

    public void setServerReplyWithMessage(ItemId value) {
        if (this.canSetFieldValue(this.serverReplyWithMessage, value)) {
            this.serverReplyWithMessage = value;
            this.changed();
        }
    }

    public boolean getStopProcessingRules() {
        return this.stopProcessingRules;
    }

    public void setStopProcessingRules(boolean value) {
        if (this.canSetFieldValue(this.stopProcessingRules, value)) {
            this.stopProcessingRules = value;
            this.changed();
        }
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("CopyToFolder")) {
            reader.readStartElement(XmlNamespace.NotSpecified, "FolderId");
            this.copyToFolder = new FolderId();
            this.copyToFolder.loadFromXml(reader, "FolderId");
            reader.readEndElement(XmlNamespace.NotSpecified, "CopyToFolder");
            return true;
        }
        if (reader.getLocalName().equals("AssignCategories")) {
            this.assignCategories.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("Delete")) {
            this.delete = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("ForwardAsAttachmentToRecipients")) {
            this.forwardAsAttachmentToRecipients.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("ForwardToRecipients")) {
            this.forwardToRecipients.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("MarkImportance")) {
            this.markImportance = reader.readElementValue(Importance.class);
            return true;
        }
        if (reader.getLocalName().equals("MarkAsRead")) {
            this.markAsRead = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("MoveToFolder")) {
            reader.readStartElement(XmlNamespace.NotSpecified, "FolderId");
            this.moveToFolder = new FolderId();
            this.moveToFolder.loadFromXml(reader, "FolderId");
            reader.readEndElement(XmlNamespace.NotSpecified, "MoveToFolder");
            return true;
        }
        if (reader.getLocalName().equals("PermanentDelete")) {
            this.permanentDelete = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("RedirectToRecipients")) {
            this.redirectToRecipients.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("SendSMSAlertToRecipients")) {
            EmailAddressCollection smsRecipientCollection = new EmailAddressCollection("Address");
            smsRecipientCollection.loadFromXml(reader, reader.getLocalName());
            this.sendSMSAlertToRecipients = RuleActions.convertSMSRecipientsFromEmailAddressCollectionToMobilePhoneCollection(smsRecipientCollection);
            return true;
        }
        if (reader.getLocalName().equals("ServerReplyWithMessage")) {
            this.serverReplyWithMessage = new ItemId();
            this.serverReplyWithMessage.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("StopProcessingRules")) {
            this.stopProcessingRules = reader.readElementValue(Boolean.class);
            return true;
        }
        return false;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.getAssignCategories().getSize() > 0) {
            this.getAssignCategories().writeToXml(writer, "AssignCategories");
        }
        if (this.getCopyToFolder() != null) {
            writer.writeStartElement(XmlNamespace.Types, "CopyToFolder");
            this.getCopyToFolder().writeToXml(writer);
            writer.writeEndElement();
        }
        if (this.getDelete()) {
            writer.writeElementValue(XmlNamespace.Types, "Delete", this.getDelete());
        }
        if (this.getForwardAsAttachmentToRecipients().getCount() > 0) {
            this.getForwardAsAttachmentToRecipients().writeToXml(writer, "ForwardAsAttachmentToRecipients");
        }
        if (this.getForwardToRecipients().getCount() > 0) {
            this.getForwardToRecipients().writeToXml(writer, "ForwardToRecipients");
        }
        if (this.getMarkImportance() != null) {
            writer.writeElementValue(XmlNamespace.Types, "MarkImportance", (Object)this.getMarkImportance());
        }
        if (this.getMarkAsRead()) {
            writer.writeElementValue(XmlNamespace.Types, "MarkAsRead", this.getMarkAsRead());
        }
        if (this.getMoveToFolder() != null) {
            writer.writeStartElement(XmlNamespace.Types, "MoveToFolder");
            this.getMoveToFolder().writeToXml(writer);
            writer.writeEndElement();
        }
        if (this.getPermanentDelete()) {
            writer.writeElementValue(XmlNamespace.Types, "PermanentDelete", this.getPermanentDelete());
        }
        if (this.getRedirectToRecipients().getCount() > 0) {
            this.getRedirectToRecipients().writeToXml(writer, "RedirectToRecipients");
        }
        if (this.getSendSMSAlertToRecipients().size() > 0) {
            EmailAddressCollection emailCollection = RuleActions.convertSMSRecipientsFromMobilePhoneCollectionToEmailAddressCollection(this.getSendSMSAlertToRecipients());
            emailCollection.writeToXml(writer, "SendSMSAlertToRecipients");
        }
        if (this.getServerReplyWithMessage() != null) {
            this.getServerReplyWithMessage().writeToXml(writer, "ServerReplyWithMessage");
        }
        if (this.getStopProcessingRules()) {
            writer.writeElementValue(XmlNamespace.Types, "StopProcessingRules", this.getStopProcessingRules());
        }
    }

    @Override
    protected void internalValidate() throws Exception {
        super.internalValidate();
        EwsUtilities.validateParam(this.forwardAsAttachmentToRecipients, "ForwardAsAttachmentToRecipients");
        EwsUtilities.validateParam(this.forwardToRecipients, "ForwardToRecipients");
        EwsUtilities.validateParam(this.redirectToRecipients, "RedirectToRecipients");
        for (MobilePhone sendSMSAlertToRecipient : this.sendSMSAlertToRecipients) {
            EwsUtilities.validateParam(sendSMSAlertToRecipient, "SendSMSAlertToRecipient");
        }
    }

    private static Collection<MobilePhone> convertSMSRecipientsFromEmailAddressCollectionToMobilePhoneCollection(EmailAddressCollection emailCollection) {
        ArrayList<MobilePhone> mobilePhoneCollection = new ArrayList<MobilePhone>();
        for (EmailAddress emailAddress : emailCollection) {
            mobilePhoneCollection.add(new MobilePhone(emailAddress.getName(), emailAddress.getAddress()));
        }
        return mobilePhoneCollection;
    }

    private static EmailAddressCollection convertSMSRecipientsFromMobilePhoneCollectionToEmailAddressCollection(Collection<MobilePhone> recipientCollection) {
        EmailAddressCollection emailCollection = new EmailAddressCollection("Address");
        for (MobilePhone recipient : recipientCollection) {
            EmailAddress emailAddress = new EmailAddress(recipient.getName(), recipient.getPhoneNumber(), MobileType);
            emailCollection.add(emailAddress);
        }
        return emailCollection;
    }
}

