/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

public final class UniqueBody
extends ComplexProperty {
    private BodyType bodyType;
    private String text;

    protected UniqueBody() {
    }

    public static String getStringFromUniqueBody(UniqueBody messageBody) throws Exception {
        EwsUtilities.validateParam(messageBody, "messageBody");
        return messageBody.text;
    }

    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.bodyType = reader.readAttributeValue(BodyType.class, "BodyType");
    }

    protected void readTextValueFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException {
        this.text = reader.readValue();
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("BodyType", (Object)this.bodyType);
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        if (this.text != null && !this.text.isEmpty()) {
            writer.writeValue(this.text, "UniqueBody");
        }
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return this.getText() == null ? "" : this.getText();
    }
}

