/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeCredentials;

public abstract class WSSecurityBasedCredentials
extends ExchangeCredentials {
    private String securityToken;
    private URI ewsUrl;
    protected static final String wsuTimeStampFormat = "<wsu:Timestamp><wsu:Created>{0:yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'}</wsu:Created><wsu:Expires>{1:yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'}</wsu:Expires></wsu:Timestamp>";
    protected static final String wsAddressingHeadersFormat = "<wsa:Action soap:mustUnderstand='1'>http://schemas.microsoft.com/exchange/services/2006/messages/%s</wsa:Action><wsa:ReplyTo><wsa:Address>http://www.w3.org/2005/08/addressing/anonymous</wsa:Address></wsa:ReplyTo><wsa:To soap:mustUnderstand='1'>%s</wsa:To>";
    protected static final String wsSecurityHeaderFormat = "<wsse:Security soap:mustUnderstand='1'>  %s</wsse:Security>";
    private boolean addTimestamp;
    protected static final String wsSecurityPathSuffix = "/wssecurity";

    protected WSSecurityBasedCredentials() {
    }

    protected WSSecurityBasedCredentials(String securityToken) {
        this.securityToken = securityToken;
    }

    protected WSSecurityBasedCredentials(String securityToken, boolean addTimestamp) {
        this.securityToken = securityToken;
        this.addTimestamp = addTimestamp;
    }

    protected void preAuthenticate() {
    }

    protected void emitExtraSoapHeaderNamespaceAliases(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeAttribute("xmlns", "wsse", null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        writer.writeAttribute("xmlns", "wsa", null, "http://www.w3.org/2005/08/addressing");
    }

    protected void serializeExtraSoapHeaders(XMLStreamWriter writer, String webMethodName) throws XMLStreamException {
        this.serializeWSAddressingHeaders(writer, webMethodName);
        this.serializeWSSecurityHeaders(writer);
    }

    private void serializeWSAddressingHeaders(XMLStreamWriter xmlWriter, String webMethodName) throws XMLStreamException {
        EwsUtilities.EwsAssert(webMethodName != null, "WSSecurityBasedCredentials.SerializeWSAddressingHeaders", "Web method name cannot be null!");
        EwsUtilities.EwsAssert(this.ewsUrl != null, "WSSecurityBasedCredentials.SerializeWSAddressingHeaders", "EWS Url cannot be null!");
        String wsAddressingHeaders = String.format(wsAddressingHeadersFormat, webMethodName, this.ewsUrl);
        xmlWriter.writeCharacters(wsAddressingHeaders);
    }

    protected void serializeWSSecurityHeaders(XMLStreamWriter xmlWriter) throws XMLStreamException {
        EwsUtilities.EwsAssert(this.securityToken != null, "WSSecurityBasedCredentials.SerializeWSSecurityHeaders", "Security token cannot be null!");
        String timestamp = null;
        if (this.addTimestamp) {
            Calendar utcNow = Calendar.getInstance();
            utcNow.add(12, 5);
            timestamp = String.format(wsuTimeStampFormat, utcNow, utcNow);
        }
        String wsSecurityHeader = String.format(wsSecurityHeaderFormat, timestamp + this.securityToken);
        xmlWriter.writeCharacters(wsSecurityHeader);
    }

    protected URI adjustUrl(URI url) throws URISyntaxException {
        return new URI(WSSecurityBasedCredentials.getUriWithoutWSSecurity(url) + wsSecurityPathSuffix);
    }

    protected String getSecurityToken() {
        return this.securityToken;
    }

    protected void setSecurityToken(String value) {
        this.securityToken = value;
    }

    protected URI getEwsUrl() {
        return this.ewsUrl;
    }

    protected void setEwsUrl(URI value) {
        this.ewsUrl = value;
    }
}

