/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.jcr.Node;
import microsoft.exchange.webservices.data.Appointment;
import microsoft.exchange.webservices.data.AppointmentSchema;
import microsoft.exchange.webservices.data.BasePropertySet;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.util.CalendarConverterService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class ExoStorageService
implements Serializable {
    private static final long serialVersionUID = 6614108102985034995L;
    private static final Log LOG = ExoLogger.getLogger(ExoStorageService.class);
    private static final DateFormat EXCLUDE_ID_FORMAT_FIRST_CHARS = new SimpleDateFormat("yyyyMMdd");
    private JCRDataStorage storage;
    private OrganizationService organizationService;
    private CorrespondenceService correspondenceService;

    public ExoStorageService(OrganizationService organizationService, CalendarService calendarService, CorrespondenceService correspondenceService) {
        this.storage = ((CalendarServiceImpl)calendarService).getDataStorage();
        this.organizationService = organizationService;
        this.correspondenceService = correspondenceService;
    }

    public void deleteEventByAppointmentID(String appointmentId, String username) throws Exception {
        CalendarEvent calendarEvent = this.getEventByAppointmentId(username, appointmentId);
        if (calendarEvent != null) {
            this.deleteEvent(username, calendarEvent);
        }
    }

    public void deleteEvent(String username, CalendarEvent calendarEvent) throws Exception {
        if (calendarEvent == null) {
            LOG.warn((Object)("Event is null, can't delete it for username: " + username));
            return;
        }
        if (!(calendarEvent.getRepeatType() != null && !calendarEvent.getRepeatType().equals(CalendarEvent.RP_NOREPEAT) || calendarEvent.getIsExceptionOccurrence() != null && calendarEvent.getIsExceptionOccurrence().booleanValue())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Delete user calendar event: " + calendarEvent.getSummary()));
            }
            this.storage.removeUserEvent(username, calendarEvent.getCalendarId(), calendarEvent.getId());
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        } else if (calendarEvent.getIsExceptionOccurrence() != null && calendarEvent.getIsExceptionOccurrence().booleanValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Delete user calendar event exceptional occurence: " + calendarEvent.getSummary() + ", id=" + calendarEvent.getRecurrenceId()));
            }
            this.storage.removeUserEvent(username, calendarEvent.getCalendarId(), calendarEvent.getId());
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        } else if (calendarEvent.getRecurrenceId() != null && !calendarEvent.getRecurrenceId().isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Delete user calendar event occurence from series: " + calendarEvent.getSummary() + " with id : " + calendarEvent.getRecurrenceId()));
            }
            this.storage.removeOccurrenceInstance(username, calendarEvent);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Delete user calendar event series: " + calendarEvent.getSummary()));
            }
            this.storage.removeRecurrenceSeries(username, calendarEvent);
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        }
    }

    public boolean deleteCalendar(String username, String folderId) throws Exception {
        List<CalendarEvent> events;
        String calendarId = this.correspondenceService.getCorrespondingId(username, folderId);
        if (calendarId == null) {
            calendarId = CalendarConverterService.getCalendarId(folderId);
        }
        if ((events = this.getUserCalendarEvents(username, folderId)) == null) {
            return false;
        }
        for (CalendarEvent calendarEvent : events) {
            this.correspondenceService.deleteCorrespondingId(username, calendarEvent.getId());
        }
        this.storage.removeUserCalendar(username, calendarId);
        this.correspondenceService.deleteCorrespondingId(username, folderId, calendarId);
        return true;
    }

    public Calendar getUserCalendar(String username, String folderId) throws Exception {
        return this.getUserCalendar(username, folderId, true);
    }

    public Calendar getUserCalendar(String username, String folderId, boolean deleteIfCorrespondentExists) throws Exception {
        String calendarId = this.correspondenceService.getCorrespondingId(username, folderId);
        Calendar calendar = null;
        if (calendarId != null && (calendar = this.storage.getUserCalendar(username, calendarId)) == null && deleteIfCorrespondentExists) {
            this.correspondenceService.deleteCorrespondingId(username, folderId);
        }
        return calendar;
    }

    public Calendar getOrCreateUserCalendar(String username, Folder folder) throws Exception {
        Calendar tmpCalendar;
        Calendar calendar = this.getUserCalendar(username, folder.getId().getUniqueId(), false);
        String calendarId = CalendarConverterService.getCalendarId(folder.getId().getUniqueId());
        if (calendar == null && (tmpCalendar = this.storage.getUserCalendar(username, calendarId)) != null) {
            this.storage.removeUserCalendar(username, calendarId);
        }
        if (calendar == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Create user calendar from Exchange: " + folder.getDisplayName()));
            }
            calendar = new Calendar();
            calendar.setId(calendarId);
            calendar.setName(CalendarConverterService.getCalendarName(folder.getDisplayName()));
            calendar.setCalendarOwner(username);
            calendar.setDataInit(false);
            calendar.setEditPermission(new String[]{"any read"});
            calendar.setCalendarColor(Calendar.COLORS[(int)(Math.random() * (double)Calendar.COLORS.length)]);
            this.storage.saveUserCalendar(username, calendar, true);
            this.correspondenceService.setCorrespondingId(username, calendar.getId(), folder.getId().getUniqueId());
        }
        return calendar;
    }

    public List<CalendarEvent> getUserCalendarEvents(String username, String folderId) throws Exception {
        Calendar calendar;
        List userEvents = null;
        String calendarId = this.correspondenceService.getCorrespondingId(username, folderId);
        if (calendarId == null) {
            calendarId = CalendarConverterService.getCalendarId(folderId);
        }
        if ((calendar = this.storage.getUserCalendar(username, calendarId)) != null) {
            ArrayList<String> calendarIds = new ArrayList<String>();
            calendarIds.add(calendarId);
            userEvents = this.storage.getUserEventByCalendar(username, calendarIds);
        }
        return userEvents;
    }

    public List<CalendarEvent> updateEvent(Appointment appointment, String username, TimeZone timeZone) throws Exception {
        return this.createOrUpdateEvent(appointment, username, false, timeZone);
    }

    public List<CalendarEvent> createEvent(Appointment appointment, String username, TimeZone timeZone) throws Exception {
        return this.createOrUpdateEvent(appointment, username, true, timeZone);
    }

    public List<CalendarEvent> createOrUpdateEvent(Appointment appointment, String username, TimeZone timeZone) throws Exception {
        CalendarEvent event;
        boolean isNew;
        boolean bl = isNew = this.correspondenceService.getCorrespondingId(username, appointment.getId().getUniqueId()) == null;
        if (!isNew && (event = this.getEventByAppointmentId(username, appointment.getId().getUniqueId())) == null) {
            isNew = true;
            this.correspondenceService.deleteCorrespondingId(username, appointment.getId().getUniqueId());
        }
        return this.createOrUpdateEvent(appointment, username, isNew, timeZone);
    }

    public CalendarEvent getEventByAppointmentId(String username, String appointmentId) throws Exception {
        String calEventId = this.correspondenceService.getCorrespondingId(username, appointmentId);
        CalendarEvent event = this.storage.getEvent(username, calEventId);
        if (event == null && calEventId != null) {
            this.correspondenceService.deleteCorrespondingId(username, appointmentId);
        }
        return event;
    }

    public CalendarEvent getExoEventByNode(Node eventNode) throws Exception {
        return this.storage.getEvent(eventNode);
    }

    public String getExoEventMasterRecurenceByOriginalUUID(String uuid) throws Exception {
        Node node = this.storage.getSession(SessionProvider.createSystemProvider()).getNodeByUUID(uuid);
        if (node == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("No original recurrent node was found with UUID: " + uuid));
            }
            return null;
        }
        return node.getName();
    }

    public List<CalendarEvent> getAllExoEvents(String username, Calendar calendar) throws Exception {
        List<String> calendarIds = Collections.singletonList(calendar.getId());
        return this.storage.getUserEventByCalendar(username, calendarIds);
    }

    public List<CalendarEvent> findExoEventsModifiedSince(String username, Calendar calendar, Date date) throws Exception {
        ArrayList<CalendarEvent> resultEvents = new ArrayList<CalendarEvent>();
        List<CalendarEvent> calendarEvents = this.getAllExoEvents(username, calendar);
        for (CalendarEvent calendarEvent : calendarEvents) {
            if (calendarEvent.getLastUpdatedTime() == null || !calendarEvent.getLastUpdatedTime().after(date)) continue;
            resultEvents.add(calendarEvent);
        }
        return resultEvents;
    }

    public void updateModifiedDateOfEvent(String username, CalendarEvent event) throws Exception {
        Node node = this.storage.getCalendarEventNode(username, event.getCalType(), event.getCalendarId(), event.getId());
        this.modifyUpdateDate(node);
        if (event.getOriginalReference() != null && !event.getOriginalReference().isEmpty()) {
            Node masterNode = this.storage.getSession(SessionProvider.createSystemProvider()).getNodeByUUID(event.getOriginalReference());
            this.modifyUpdateDate(masterNode);
        }
    }

    private void modifyUpdateDate(Node node) throws Exception {
        if (!node.isNodeType("exo:datetime")) {
            if (node.canAddMixin("exo:datetime")) {
                node.addMixin("exo:datetime");
            }
            node.setProperty("exo:dateCreated", (java.util.Calendar)new GregorianCalendar());
        }
        node.setProperty("exo:dateModified", (java.util.Calendar)new GregorianCalendar());
        node.save();
    }

    private List<CalendarEvent> createOrUpdateEvent(Appointment appointment, String username, boolean isNew, TimeZone timeZone) throws Exception {
        Calendar calendar = this.getUserCalendar(username, appointment.getParentFolderId().getUniqueId());
        if (calendar == null) {
            LOG.warn((Object)"Attempting to synchronize an event without existing associated eXo Calendar.");
            return null;
        }
        ArrayList<CalendarEvent> updatedEvents = new ArrayList<CalendarEvent>();
        if (appointment.getAppointmentType() != null) {
            switch (appointment.getAppointmentType()) {
                case Single: {
                    CalendarEvent event = null;
                    if (isNew) {
                        event = new CalendarEvent();
                        event.setCalendarId(calendar.getId());
                        updatedEvents.add(event);
                    } else {
                        event = this.getEventByAppointmentId(username, appointment.getId().getUniqueId());
                        updatedEvents.add(event);
                        if (CalendarConverterService.verifyModifiedDatesConflict(event, appointment)) {
                            if (LOG.isTraceEnabled()) {
                                LOG.trace((Object)"Attempting to update eXo Event with Exchange Event, but modification date of eXo is after, ignore updating.");
                            }
                            return updatedEvents;
                        }
                    }
                    if (LOG.isTraceEnabled()) {
                        if (isNew) {
                            LOG.trace((Object)("Create user calendar event: " + appointment.getSubject()));
                        } else {
                            LOG.trace((Object)("Update user calendar event: " + appointment.getSubject()));
                        }
                    }
                    CalendarConverterService.convertExchangeToExoEvent(event, appointment, username, this.storage, this.organizationService.getUserHandler(), timeZone);
                    event.setRepeatType(CalendarEvent.RP_NOREPEAT);
                    this.storage.saveUserEvent(username, calendar.getId(), event, isNew);
                    this.correspondenceService.setCorrespondingId(username, event.getId(), appointment.getId().getUniqueId());
                    break;
                }
                case Exception: {
                    throw new IllegalStateException("The appointment is an exception occurence of this event >> '" + appointment.getSubject() + "'. start:" + appointment.getStart() + ", end : " + appointment.getEnd() + ", occurence: " + appointment.getAppointmentSequenceNumber());
                }
                case RecurringMaster: {
                    CalendarEvent masterEvent = null;
                    Date orginialStartDate = null;
                    if (isNew) {
                        masterEvent = new CalendarEvent();
                        updatedEvents.add(masterEvent);
                    } else {
                        masterEvent = this.getEventByAppointmentId(username, appointment.getId().getUniqueId());
                        updatedEvents.add(masterEvent);
                        orginialStartDate = masterEvent.getFromDateTime();
                    }
                    boolean isLastOccurenceDeleted = false;
                    appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Recurrence}));
                    if (appointment.getRecurrence().hasEnd()) {
                        Date recEndDate = appointment.getRecurrence().getEndDate();
                        boolean bl = isLastOccurenceDeleted = (appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.LastOccurrence}))).getLastOccurrence().getEnd().getDate() < recEndDate.getDate();
                        if (isLastOccurenceDeleted && masterEvent.getExcludeId() != null) {
                            String pattern = EXCLUDE_ID_FORMAT_FIRST_CHARS.format(recEndDate);
                            for (int i = 0; isLastOccurenceDeleted && i < masterEvent.getExcludeId().length; ++i) {
                                isLastOccurenceDeleted = !masterEvent.getExcludeId()[i].startsWith(pattern);
                            }
                        }
                    }
                    appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                    if (!isLastOccurenceDeleted && !isNew && CalendarConverterService.verifyModifiedDatesConflict(masterEvent, appointment)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)"Attempting to update eXo Event with Exchange Event, but modification date of eXo is after, ignore updating.");
                        }
                        return updatedEvents;
                    }
                    if (LOG.isTraceEnabled()) {
                        if (isNew) {
                            LOG.trace((Object)("Create recurrent user calendar event: " + appointment.getSubject()));
                        } else {
                            LOG.trace((Object)("Update recurrent user calendar event: " + appointment.getSubject()));
                        }
                    }
                    masterEvent.setCalendarId(calendar.getId());
                    CalendarConverterService.convertExchangeToExoMasterRecurringCalendarEvent(masterEvent, appointment, username, this.storage, this.organizationService.getUserHandler(), timeZone);
                    if (isNew) {
                        this.correspondenceService.setCorrespondingId(username, masterEvent.getId(), appointment.getId().getUniqueId());
                    } else if (!CalendarConverterService.isSameDate(orginialStartDate, masterEvent.getFromDateTime()) && masterEvent.getExcludeId() == null) {
                        masterEvent.setExcludeId(new String[0]);
                    }
                    this.storage.saveUserEvent(username, calendar.getId(), masterEvent, isNew);
                    ArrayList<CalendarEvent> exceptionalEventsToUpdate = new ArrayList<CalendarEvent>();
                    ArrayList<String> occAppointmentIDs = new ArrayList<String>();
                    List<CalendarEvent> toDeleteEvents = CalendarConverterService.convertExchangeToExoOccurenceEvent(masterEvent, exceptionalEventsToUpdate, occAppointmentIDs, appointment, username, this.storage, this.organizationService.getUserHandler(), this.correspondenceService, timeZone);
                    if (exceptionalEventsToUpdate != null && !exceptionalEventsToUpdate.isEmpty()) {
                        this.storage.updateOccurrenceEvent(calendar.getId(), calendar.getId(), masterEvent.getCalType(), masterEvent.getCalType(), exceptionalEventsToUpdate, username);
                        Iterator eventsIterator = exceptionalEventsToUpdate.iterator();
                        Iterator occAppointmentIdIterator = occAppointmentIDs.iterator();
                        while (eventsIterator.hasNext()) {
                            CalendarEvent calendarEvent = (CalendarEvent)eventsIterator.next();
                            String occAppointmentId = (String)occAppointmentIdIterator.next();
                            this.correspondenceService.setCorrespondingId(username, calendarEvent.getId(), occAppointmentId);
                        }
                        updatedEvents.addAll(exceptionalEventsToUpdate);
                    }
                    if (toDeleteEvents == null || toDeleteEvents.isEmpty()) break;
                    for (CalendarEvent calendarEvent : toDeleteEvents) {
                        this.deleteEvent(username, calendarEvent);
                    }
                    break;
                }
                case Occurrence: {
                    LOG.warn((Object)("The appointment is an occurence of this event >> '" + appointment.getSubject() + "'. start:" + appointment.getStart() + ", end : " + appointment.getEnd() + ", occurence: " + appointment.getAppointmentSequenceNumber()));
                }
            }
        }
        return updatedEvents;
    }
}

