/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import microsoft.exchange.webservices.data.Appointment;
import microsoft.exchange.webservices.data.AppointmentSchema;
import microsoft.exchange.webservices.data.AttachmentCollection;
import microsoft.exchange.webservices.data.Attendee;
import microsoft.exchange.webservices.data.AttendeeCollection;
import microsoft.exchange.webservices.data.BasePropertySet;
import microsoft.exchange.webservices.data.BodyType;
import microsoft.exchange.webservices.data.DayOfTheWeek;
import microsoft.exchange.webservices.data.DeletedOccurrenceInfo;
import microsoft.exchange.webservices.data.DeletedOccurrenceInfoCollection;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.FileAttachment;
import microsoft.exchange.webservices.data.Importance;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.MessageBody;
import microsoft.exchange.webservices.data.OccurrenceInfo;
import microsoft.exchange.webservices.data.OccurrenceInfoCollection;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.Recurrence;
import microsoft.exchange.webservices.data.Sensitivity;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

public class CalendarConverterService {
    private static final Log LOG = ExoLogger.getLogger(CalendarConverterService.class);
    public static final String EXCHANGE_CALENDAR_NAME_PREFIX = "EXCH";
    public static final String EXCHANGE_CALENDAR_ID_PREFIX = "EXCH";
    public static final String EXCHANGE_EVENT_ID_PREFIX = "ExcangeEvent";
    private static final SimpleDateFormat UTC_DATE_FORMAT = new SimpleDateFormat("dd MMM yyyy HH:mm:ss");
    public static final SimpleDateFormat RECURRENCE_ID_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    private static final ThreadLocal<Query> queryThreadLocal = new ThreadLocal();

    public static void convertExchangeToExoEvent(CalendarEvent event, Appointment appointment, String username, JCRDataStorage storage, UserHandler userHandler, TimeZone timeZone) throws Exception {
        if (event.getId() == null || event.getId().isEmpty()) {
            event.setId(CalendarConverterService.getEventId(appointment.getId().getUniqueId()));
        }
        if (event.getEventType() == null) {
            event.setEventType(CalendarEvent.TYPE_EVENT);
            event.setCalType("0");
        }
        event.setLocation(appointment.getLocation());
        event.setSummary(appointment.getSubject());
        CalendarConverterService.setEventStatus(event, appointment);
        CalendarConverterService.setEventDates(event, appointment, timeZone);
        CalendarConverterService.setEventPriority(event, appointment);
        CalendarConverterService.setEventCategory(event, appointment, username, storage);
        CalendarConverterService.setEventParticipants(event, appointment, userHandler);
        CalendarConverterService.setEventReminder(event, appointment, username);
        if (appointment.getSensitivity() != null && !appointment.getSensitivity().equals((Object)Sensitivity.Normal)) {
            event.setPrivate(true);
        } else {
            event.setPrivate(false);
        }
        CalendarConverterService.setEventAttachements(event, appointment);
        CalendarConverterService.setEventDescription(event, appointment);
    }

    public static void convertExchangeToExoMasterRecurringCalendarEvent(CalendarEvent event, Appointment appointment, String username, JCRDataStorage storage, UserHandler userHandler, TimeZone timeZone) throws Exception {
        CalendarConverterService.convertExchangeToExoEvent(event, appointment, username, storage, userHandler, timeZone);
        appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Recurrence}));
        Recurrence recurrence = appointment.getRecurrence();
        if (recurrence instanceof Recurrence.DailyPattern) {
            event.setRepeatType(CalendarEvent.RP_DAILY);
        } else if (recurrence instanceof Recurrence.WeeklyPattern) {
            event.setRepeatType(CalendarEvent.RP_WEEKEND);
        } else if (recurrence instanceof Recurrence.MonthlyPattern) {
            event.setRepeatType(CalendarEvent.RP_MONTHLY);
        } else if (recurrence instanceof Recurrence.YearlyPattern) {
            event.setRepeatType(CalendarEvent.RP_YEARLY);
        }
        if (recurrence instanceof Recurrence.IntervalPattern && ((Recurrence.IntervalPattern)recurrence).getInterval() > 0) {
            event.setRepeatInterval((long)((Recurrence.IntervalPattern)recurrence).getInterval());
        }
        if (recurrence.getEndDate() != null) {
            event.setRepeatUntilDate(CalendarConverterService.getExoDateFromExchangeFormat(recurrence.getEndDate()));
        }
        if (recurrence.getNumberOfOccurrences() != null) {
            event.setRepeatCount((long)recurrence.getNumberOfOccurrences().intValue());
        }
    }

    public static List<CalendarEvent> convertExchangeToExoOccurenceEvent(CalendarEvent masterEvent, List<CalendarEvent> updatedEvents, List<String> appointmentIds, Appointment masterAppointment, String username, JCRDataStorage storage, UserHandler userHandler, CorrespondenceService correspondenceService, TimeZone timeZone) throws Exception {
        OccurrenceInfoCollection occurrenceInfoCollection = (masterAppointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.ModifiedOccurrences}))).getModifiedOccurrences();
        if (occurrenceInfoCollection != null && occurrenceInfoCollection.getCount() > 0) {
            for (OccurrenceInfo occurrenceInfo : occurrenceInfoCollection) {
                Appointment occurenceAppointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)occurrenceInfo.getItemId(), (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                CalendarEvent tmpEvent = CalendarConverterService.getOccurenceOfDate(username, storage, masterEvent, occurrenceInfo.getOriginalStart(), timeZone);
                if (CalendarConverterService.verifyModifiedDatesConflict(tmpEvent, occurenceAppointment)) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)"Attempting to update eXo Occurent Event with Exchange Event, but modification date of eXo is after, ignore updating.");
                    continue;
                }
                if (tmpEvent == null || tmpEvent.getIsExceptionOccurrence() == null || !tmpEvent.getIsExceptionOccurrence().booleanValue()) {
                    tmpEvent = new CalendarEvent();
                    CalendarConverterService.convertExchangeToExoEvent(tmpEvent, occurenceAppointment, username, storage, userHandler, timeZone);
                    tmpEvent.setRecurrenceId(RECURRENCE_ID_FORMAT.format(tmpEvent.getFromDateTime()));
                    tmpEvent.setRepeatType(CalendarEvent.RP_NOREPEAT);
                    tmpEvent.setId(masterEvent.getId());
                    tmpEvent.setCalendarId(masterEvent.getCalendarId());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Create exo calendar Occurence event: " + tmpEvent.getSummary() + ", with recurence id: " + tmpEvent.getRecurrenceId()));
                    }
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Update exo calendar Occurence event: " + tmpEvent.getSummary() + ", with recurence id: " + tmpEvent.getRecurrenceId()));
                    }
                    CalendarConverterService.convertExchangeToExoEvent(tmpEvent, occurenceAppointment, username, storage, userHandler, timeZone);
                }
                updatedEvents.add(tmpEvent);
                appointmentIds.add(occurenceAppointment.getId().getUniqueId());
            }
        }
        masterAppointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.DeletedOccurrences}));
        ArrayList<CalendarEvent> calendarEvents = new ArrayList<CalendarEvent>();
        DeletedOccurrenceInfoCollection deletedOccurrenceInfoCollection = masterAppointment.getDeletedOccurrences();
        if (deletedOccurrenceInfoCollection != null && deletedOccurrenceInfoCollection.getCount() > 0) {
            for (DeletedOccurrenceInfo occurrenceInfo : deletedOccurrenceInfoCollection) {
                CalendarEvent toDeleteEvent = CalendarConverterService.getOccurenceOfDate(username, storage, masterEvent, occurrenceInfo.getOriginalStart(), timeZone);
                if (toDeleteEvent == null) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Occurence is already deleted from recurrent Event: " + masterEvent.getSummary()));
                    continue;
                }
                String appId = correspondenceService.getCorrespondingId(username, toDeleteEvent.getId());
                Appointment appointment = null;
                try {
                    appointment = Appointment.bind((ExchangeService)masterAppointment.getService(), (ItemId)ItemId.getItemIdFromString((String)appId));
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (appointment != null && toDeleteEvent.getIsExceptionOccurrence() != null && toDeleteEvent.getIsExceptionOccurrence().booleanValue()) continue;
                calendarEvents.add(toDeleteEvent);
            }
        }
        return calendarEvents;
    }

    public static boolean verifyModifiedDatesConflict(CalendarEvent event, Appointment item) throws Exception {
        if (event.getLastUpdatedTime() == null) {
            return false;
        }
        if (item.getLastModifiedTime() == null) {
            return true;
        }
        Date eventModifDate = CalendarConverterService.convertDateToUTC(event.getLastUpdatedTime());
        Date itemModifDate = item.getLastModifiedTime();
        return eventModifDate.getTime() >= itemModifDate.getTime();
    }

    public static void convertExoToExchangeEvent(Appointment appointment, CalendarEvent calendarEvent, String username, UserHandler userHandler, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        CalendarConverterService.setAppointmentStatus(appointment, calendarEvent);
        CalendarConverterService.setAppointmentDates(appointment, calendarEvent, serverTimeZoneDefinition, userCalendarTimeZone);
        CalendarConverterService.setAppointmentPriority(appointment, calendarEvent);
        CalendarConverterService.setAppointmentCategory(appointment, calendarEvent);
        CalendarConverterService.setAppointmentAttendees(appointment, calendarEvent, userHandler, username);
        CalendarConverterService.setAppointmentReminder(appointment, calendarEvent);
        appointment.setLocation(calendarEvent.getLocation());
        appointment.setSubject((Object)calendarEvent.getSummary());
        if (calendarEvent.isPrivate()) {
            appointment.setSensitivity(Sensitivity.Private);
        } else {
            appointment.setSensitivity(Sensitivity.Normal);
        }
        CalendarConverterService.setAppointmentAttachements(appointment, calendarEvent);
        CalendarConverterService.setApoinementSummary(appointment, calendarEvent);
    }

    public static List<Appointment> convertExoToExchangeMasterRecurringCalendarEvent(Appointment appointment, CalendarEvent event, String username, UserHandler userHandler, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        List<Appointment> toDeleteOccurences = null;
        CalendarConverterService.convertExoToExchangeEvent(appointment, event, username, userHandler, serverTimeZoneDefinition, userCalendarTimeZone);
        String repeatType = event.getRepeatType();
        assert (repeatType != null && !repeatType.equals(CalendarEvent.RP_NOREPEAT));
        Recurrence.DailyPattern recurrence = null;
        if (repeatType.equals(CalendarEvent.RP_DAILY)) {
            recurrence = new Recurrence.DailyPattern();
        } else if (repeatType.equals(CalendarEvent.RP_WEEKEND)) {
            recurrence = new Recurrence.WeeklyPattern();
        } else if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
            recurrence = new Recurrence.MonthlyPattern();
        } else if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
            recurrence = new Recurrence.YearlyPattern();
        } else if (repeatType.equals(CalendarEvent.RP_WORKINGDAYS)) {
            recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Weekday});
        } else if (repeatType.equals(CalendarEvent.RP_WEEKEND)) {
            recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.WeekendDay});
        } else {
            if (repeatType.equals(CalendarEvent.RP_WEEKLY_BYDAY[0])) {
                recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Monday});
            } else if (repeatType.equals(CalendarEvent.RP_WEEKLY_BYDAY[1])) {
                recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Tuesday});
            }
            if (repeatType.equals(CalendarEvent.RP_WEEKLY_BYDAY[2])) {
                recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Wednesday});
            }
            if (repeatType.equals(CalendarEvent.RP_WEEKLY_BYDAY[3])) {
                recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Thursday});
            }
            if (repeatType.equals(CalendarEvent.RP_WEEKLY_BYDAY[4])) {
                recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Friday});
            }
            if (repeatType.equals(CalendarEvent.RP_WEEKLY_BYDAY[5])) {
                recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Saturday});
            }
            if (repeatType.equals(CalendarEvent.RP_WEEKLY_BYDAY[6])) {
                recurrence = new Recurrence.WeeklyPattern(event.getFromDateTime(), (int)event.getRepeatInterval(), new DayOfTheWeek[]{DayOfTheWeek.Sunday});
            }
        }
        recurrence.setStartDate(event.getFromDateTime());
        if (event.getRepeatUntilDate() == null && event.getRepeatCount() < 1L) {
            recurrence.neverEnds();
        } else if (event.getRepeatUntilDate() != null) {
            recurrence.setEndDate(CalendarConverterService.getExchangeDateFromExchangeFormat(event.getRepeatUntilDate()));
        } else {
            recurrence.setNumberOfOccurrences(Integer.valueOf((int)event.getRepeatCount()));
        }
        appointment.setRecurrence((Recurrence)recurrence);
        if (event.getExcludeId() != null && event.getExcludeId().length > 0) {
            toDeleteOccurences = CalendarConverterService.getDeletedOccurences(appointment, event, userCalendarTimeZone);
            int nbOccurences = recurrence.getNumberOfOccurrences() == null ? 0 : recurrence.getNumberOfOccurrences();
            int deletedAppointmentOccurences = 0;
            try {
                deletedAppointmentOccurences = appointment.getDeletedOccurrences().getCount();
            }
            catch (Exception e) {
                try {
                    appointment = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                    deletedAppointmentOccurences = appointment.getDeletedOccurrences().getCount();
                }
                catch (Exception e2) {
                    deletedAppointmentOccurences = 0;
                }
            }
            if (nbOccurences - deletedAppointmentOccurences - toDeleteOccurences.size() == 0) {
                toDeleteOccurences.clear();
                toDeleteOccurences.add(appointment);
            }
        }
        return toDeleteOccurences;
    }

    public static void convertExoToExchangeOccurenceEvent(Appointment occAppointment, CalendarEvent occEvent, String username, UserHandler userHandler, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        CalendarConverterService.convertExoToExchangeEvent(occAppointment, occEvent, username, userHandler, serverTimeZoneDefinition, userCalendarTimeZone);
    }

    public static String getCalendarName(String calendarName) {
        return "EXCH-" + calendarName;
    }

    public static String getCalendarId(String folderId) {
        return "EXCH-" + folderId.hashCode();
    }

    public static boolean isExchangeCalendarId(String calendarId) {
        return calendarId != null && calendarId.startsWith("EXCH");
    }

    public static boolean isExchangeEventId(String eventId) {
        return eventId != null && eventId.startsWith(EXCHANGE_EVENT_ID_PREFIX);
    }

    public static String getEventId(String appointmentId) throws Exception {
        return EXCHANGE_EVENT_ID_PREFIX + appointmentId.hashCode();
    }

    public static boolean isSameDate(Date value1, Date value2) {
        Calendar date1 = Calendar.getInstance();
        date1.setTime(value1);
        Calendar date2 = Calendar.getInstance();
        date2.setTime(value2);
        return CalendarConverterService.isSameDate(date1, date2);
    }

    public static boolean isAllDayEvent(CalendarEvent eventCalendar, TimeZone userCalendarTimeZone) {
        Calendar cal1 = Calendar.getInstance(userCalendarTimeZone);
        cal1.setLenient(false);
        Calendar cal2 = Calendar.getInstance(userCalendarTimeZone);
        cal2.setLenient(false);
        cal1.setTime(eventCalendar.getFromDateTime());
        cal2.setTime(eventCalendar.getToDateTime());
        return cal1.get(11) == 0 && cal1.get(12) == 0 && cal2.get(11) == cal2.getActualMaximum(11) && cal2.get(12) == cal2.getActualMaximum(12);
    }

    public static Date convertDateToUTC(Date date) throws ParseException {
        UTC_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        String time = UTC_DATE_FORMAT.format(date);
        UTC_DATE_FORMAT.setTimeZone(TimeZone.getDefault());
        return UTC_DATE_FORMAT.parse(time);
    }

    public static Date getExoDateFromExchangeFormat(Date date) {
        int exchangeOffset = TimeZone.getDefault().getOffset(date.getTime()) / 60000;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, exchangeOffset);
        return calendar.getTime();
    }

    public static Appointment getAppointmentOccurence(Appointment masterAppointment, String recurrenceId) throws Exception {
        Appointment appointment = null;
        Date occDate = RECURRENCE_ID_FORMAT.parse(recurrenceId);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(occDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        occDate = calendar.getTime();
        Date endDate = masterAppointment.getRecurrence().getEndDate();
        if (endDate != null && occDate.getTime() > endDate.getTime()) {
            return null;
        }
        Integer nbOccurences = masterAppointment.getRecurrence().getNumberOfOccurrences();
        Calendar indexCalendar = Calendar.getInstance();
        indexCalendar.setTime(masterAppointment.getRecurrence().getStartDate());
        boolean continueSearch = true;
        for (int i = 1; continueSearch && (nbOccurences == null || i <= nbOccurences); ++i) {
            Appointment tmpAppointment = null;
            try {
                tmpAppointment = Appointment.bindToOccurrence((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (int)i, (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Start}));
                Date date = CalendarConverterService.getExoDateFromExchangeFormat(tmpAppointment.getStart());
                if (CalendarConverterService.isSameDate(occDate, date)) {
                    appointment = Appointment.bindToOccurrence((ExchangeService)masterAppointment.getService(), (ItemId)masterAppointment.getId(), (int)i, (PropertySet)new PropertySet(BasePropertySet.FirstClassProperties));
                    continueSearch = false;
                }
                indexCalendar.setTime(date);
                continue;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Error while getting occurence: " + recurrenceId + " of master appointment : " + masterAppointment.getSubject()), (Throwable)e);
                }
                indexCalendar.add(5, 1);
            }
            if (!continueSearch || !occDate.before(indexCalendar.getTime()) && (endDate == null || !indexCalendar.getTime().after(endDate))) continue;
            continueSearch = false;
        }
        return appointment;
    }

    private static Date getExchangeDateFromExchangeFormat(Date date) {
        int exchangeOffset = TimeZone.getDefault().getOffset(date.getTime()) / 60000;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, -exchangeOffset);
        return calendar.getTime();
    }

    private static CalendarEvent getOccurenceOfDate(String username, JCRDataStorage storage, CalendarEvent masterEvent, Date originalStart, TimeZone timeZone) throws Exception {
        Date date = CalendarConverterService.getExoDateFromExchangeFormat(originalStart);
        String recurenceId = RECURRENCE_ID_FORMAT.format(date);
        List exceptionEvents = storage.getExceptionEvents(username, masterEvent);
        if (exceptionEvents != null && !exceptionEvents.isEmpty()) {
            for (CalendarEvent calendarEvent : exceptionEvents) {
                if (!calendarEvent.getRecurrenceId().equals(recurenceId)) continue;
                return calendarEvent;
            }
        }
        Calendar from = Calendar.getInstance(timeZone);
        from.setTime(date);
        from.set(11, 0);
        from.set(12, 0);
        from.set(13, 0);
        from.set(14, 0);
        Calendar to = Calendar.getInstance(timeZone);
        to.setTime(date);
        to.set(11, to.getActualMaximum(11));
        to.set(12, to.getActualMaximum(12));
        to.set(13, to.getActualMaximum(13));
        to.set(14, to.getActualMaximum(14));
        Map map = storage.getOccurrenceEvents(masterEvent, from, to, timeZone.getID());
        CalendarEvent occEvent = null;
        if (map != null && !map.isEmpty()) {
            if (map.size() == 1) {
                occEvent = (CalendarEvent)map.values().iterator().next();
            } else {
                LOG.error((Object)("Error while deleting from eXo an occurence already deleted from Exchange '" + masterEvent.getSummary() + "' in date: '" + date + "'"));
            }
        }
        return occEvent;
    }

    private static void setAppointmentReminder(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        appointment.setIsReminderSet(Boolean.valueOf(false));
        List reminders = calendarEvent.getReminders();
        if (reminders != null) {
            for (Reminder reminder : reminders) {
                appointment.setIsReminderSet(Boolean.valueOf(true));
                appointment.setReminderMinutesBeforeStart((int)reminder.getAlarmBefore());
                appointment.setReminderDueBy(CalendarConverterService.convertToDefaultTimeZoneFormat(reminder.getFromDateTime()));
            }
        }
    }

    private static List<Appointment> getDeletedOccurences(Appointment masterAppointment, CalendarEvent event, TimeZone userCalendarTimeZone) throws Exception {
        String[] excludedRecurenceIds;
        ArrayList<Appointment> toDeleteOccurence = new ArrayList<Appointment>();
        for (String excludedRecurenceId : excludedRecurenceIds = event.getExcludeId()) {
            Appointment occAppointment;
            if (excludedRecurenceId.isEmpty() || (occAppointment = CalendarConverterService.getAppointmentOccurence(masterAppointment, excludedRecurenceId)) == null) continue;
            toDeleteOccurence.add(occAppointment);
        }
        return toDeleteOccurence;
    }

    private static String getCategoryName(String categoryName) {
        return categoryName;
    }

    private static boolean isSameDate(Calendar date1, Calendar date2) {
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    private static void setAppointmentAttendees(Appointment appointment, CalendarEvent calendarEvent, UserHandler userHandler, String username) throws ServiceLocalException {
        AttendeeCollection attendees = appointment.getRequiredAttendees();
        assert (attendees != null);
        CalendarConverterService.computeAttendies(userHandler, username, attendees, calendarEvent.getParticipant());
        attendees = appointment.getOptionalAttendees();
        assert (attendees != null);
        CalendarConverterService.computeAttendies(userHandler, username, attendees, calendarEvent.getInvitation());
    }

    private static void computeAttendies(UserHandler userHandler, String username, AttendeeCollection attendees, String[] participants) {
        if (participants != null && participants.length > 0) {
            for (String partacipant : participants) {
                Attendee attendee;
                if (partacipant == null || partacipant.isEmpty() || partacipant.equals(username)) continue;
                try {
                    User user = userHandler.findUserByName(partacipant);
                    if (CalendarConverterService.containsAttendee(attendees, user.getEmail())) continue;
                    attendee = new Attendee(user.getDisplayName(), user.getEmail());
                    attendees.add(attendee);
                }
                catch (Exception e) {
                    attendee = null;
                    attendee = username.contains("@") ? new Attendee(username.split("@")[0], username) : new Attendee(username, null);
                    attendees.add(attendee);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.warn((Object)("Partacipant '" + partacipant + "' wasn't found in eXo Organization."));
                }
            }
        }
    }

    private static boolean containsAttendee(AttendeeCollection attendees, String email) {
        for (Attendee attendee : attendees) {
            if (!attendee.getAddress().equals(email)) continue;
            return true;
        }
        return false;
    }

    private static void setEventParticipants(CalendarEvent calendarEvent, Appointment appointment, UserHandler userHandler) throws ServiceLocalException {
        Query query = queryThreadLocal.get();
        if (query == null) {
            query = new Query();
            queryThreadLocal.set(query);
        }
        ArrayList<String> participants = new ArrayList<String>();
        CalendarConverterService.addEventPartacipants(appointment.getRequiredAttendees(), userHandler, query, participants);
        CalendarConverterService.addEventPartacipants(appointment.getOptionalAttendees(), userHandler, query, participants);
        CalendarConverterService.addEventPartacipants(appointment.getResources(), userHandler, query, participants);
        if (participants.size() > 0) {
            calendarEvent.setParticipant(participants.toArray(new String[0]));
        }
    }

    private static void addEventPartacipants(AttendeeCollection attendeeCollection, UserHandler userHandler, Query query, List<String> participants) throws ServiceLocalException {
        if (attendeeCollection != null) {
            for (Attendee attendee : attendeeCollection) {
                if (attendee.getAddress() == null || attendee.getAddress().isEmpty()) continue;
                String username = CalendarConverterService.getPartacipantUserName(userHandler, query, attendee);
                if (username == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Event partacipant was not found, email = " + attendee.getAddress()));
                    }
                    String string = username = attendee.getAddress() == null ? attendee.getName() : attendee.getAddress();
                    if (username == null) {
                        LOG.warn((Object)("No user found for attendee: " + attendee));
                        continue;
                    }
                }
                participants.add(username);
            }
        }
    }

    private static String getPartacipantUserName(UserHandler userHandler, Query query, Attendee attendee) {
        String username;
        block8: {
            username = null;
            query.setEmail(attendee.getAddress());
            try {
                ListAccess listAccess = userHandler.findUsersByQuery(query);
                if (listAccess == null || listAccess.getSize() == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("User with email '" + attendee.getAddress() + "' was not found in eXo."));
                    }
                } else if (listAccess.getSize() > 1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.warn((Object)("Multiple users have the same email adress: '" + attendee.getAddress() + "'."));
                    }
                } else {
                    username = ((User[])listAccess.load(0, 1))[0].getUserName();
                }
            }
            catch (Exception e) {
                if (!LOG.isTraceEnabled()) break block8;
                LOG.trace((Object)("exception occured while trying to get user with email " + attendee.getAddress()), (Throwable)e);
            }
        }
        return username;
    }

    private static void setAppointmentPriority(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        if (calendarEvent.getPriority() == null || calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_NONE) || calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_NORMAL)) {
            appointment.setImportance(Importance.Normal);
        } else if (calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_LOW)) {
            appointment.setImportance(Importance.Low);
        } else if (calendarEvent.getPriority().equals(CalendarEvent.PRIORITY_HIGH)) {
            appointment.setImportance(Importance.High);
        }
    }

    private static void setEventPriority(CalendarEvent calendarEvent, Appointment appointment) throws ServiceLocalException {
        if (appointment.getImportance() != null) {
            switch (appointment.getImportance()) {
                case High: {
                    calendarEvent.setPriority(CalendarEvent.PRIORITY_HIGH);
                    break;
                }
                case Low: {
                    calendarEvent.setPriority(CalendarEvent.PRIORITY_LOW);
                    break;
                }
                case Normal: {
                    calendarEvent.setPriority(CalendarEvent.PRIORITY_NORMAL);
                }
            }
        } else {
            calendarEvent.setPriority(CalendarEvent.PRIORITY_NONE);
        }
    }

    private static void setAppointmentDates(Appointment appointment, CalendarEvent calendarEvent, TimeZoneDefinition serverTimeZoneDefinition, TimeZone userCalendarTimeZone) throws Exception {
        boolean isAllDay = CalendarConverterService.isAllDayEvent(calendarEvent, userCalendarTimeZone);
        Calendar calendar = Calendar.getInstance();
        if (isAllDay) {
            calendar.setTime(calendarEvent.getFromDateTime());
            calendar.add(11, 12);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            calendar.setTime(CalendarConverterService.convertToDefaultTimeZoneFormat(calendarEvent.getFromDateTime()));
        }
        appointment.setStart(calendar.getTime());
        if (isAllDay) {
            calendar.setTime(calendarEvent.getToDateTime());
            calendar.add(11, -12);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            calendar.setTime(CalendarConverterService.convertToDefaultTimeZoneFormat(calendarEvent.getToDateTime()));
        }
        appointment.setEnd(calendar.getTime());
        appointment.setIsAllDayEvent(Boolean.valueOf(isAllDay));
    }

    private static void setEventDates(CalendarEvent calendarEvent, Appointment appointment, TimeZone timeZone) throws ServiceLocalException {
        calendarEvent.setFromDateTime(CalendarConverterService.getExoDateFromExchangeFormat(appointment.getStart()));
        calendarEvent.setToDateTime(CalendarConverterService.getExoDateFromExchangeFormat(appointment.getEnd()));
        if (appointment.getIsAllDayEvent().booleanValue()) {
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(calendarEvent.getFromDateTime());
            cal1.add(11, 12);
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal2.setTime(calendarEvent.getToDateTime());
            if (cal2.get(11) == 0) {
                cal2.add(11, -1);
            } else {
                cal2.add(11, 12);
            }
            cal2.set(11, cal2.getActualMaximum(11));
            cal2.set(12, cal2.getActualMaximum(12));
            calendarEvent.setFromDateTime(CalendarConverterService.convertToUserTimeZoneFormat(cal1.getTime(), timeZone));
            calendarEvent.setToDateTime(CalendarConverterService.convertToUserTimeZoneFormat(cal2.getTime(), timeZone));
        }
    }

    private static Date convertToDefaultTimeZoneFormat(Date date) {
        int originalOffset = TimeZone.getDefault().getOffset(date.getTime()) / 60000;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, -originalOffset);
        return calendar.getTime();
    }

    private static Date convertToUserTimeZoneFormat(Date date, TimeZone timeZone) {
        int originalOffset = TimeZone.getDefault().getOffset(date.getTime()) / 60000;
        int userTZOffset = timeZone.getRawOffset() / 60000;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, originalOffset - userTZOffset);
        return calendar.getTime();
    }

    private static void setAppointmentCategory(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        if (appointment.getCategories() != null) {
            appointment.getCategories().clearList();
        }
        if (calendarEvent.getEventCategoryName() != null && !calendarEvent.getEventCategoryName().isEmpty() && !calendarEvent.getEventCategoryId().equals("defaultEventCategoryIdAll")) {
            if (appointment.getCategories() == null) {
                StringList stringList = new StringList();
                appointment.setCategories(stringList);
            }
            if (!appointment.getCategories().contains(calendarEvent.getEventCategoryName())) {
                appointment.getCategories().add(calendarEvent.getEventCategoryName());
            }
        }
    }

    private static void setEventCategory(CalendarEvent calendarEvent, Appointment appointment, String username, JCRDataStorage storage) throws Exception {
        String categoryName;
        if (appointment.getCategories() != null && appointment.getCategories().getSize() > 0 && (categoryName = appointment.getCategories().getString(0)) != null && !categoryName.isEmpty()) {
            EventCategory category = CalendarConverterService.getEventCategoryByName(storage, username, CalendarConverterService.getCategoryName(categoryName));
            if (category == null) {
                category = new EventCategory();
                category.setDataInit(false);
                category.setName(CalendarConverterService.getCategoryName(categoryName));
                category.setId(CalendarConverterService.getCategoryName(categoryName));
                storage.saveEventCategory(username, category, true);
            }
            calendarEvent.setEventCategoryId(category.getId());
            calendarEvent.setEventCategoryName(category.getName());
        }
    }

    private static void setAppointmentAttachements(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        List attachments = calendarEvent.getAttachment();
        if (attachments != null && !attachments.isEmpty()) {
            AttachmentCollection attachmentCollection = appointment.getAttachments();
            assert (attachmentCollection != null);
            for (Attachment attachment : attachments) {
                FileAttachment fileAttachment = attachmentCollection.addFileAttachment(attachment.getName(), attachment.getInputStream());
                fileAttachment.setContentType(attachment.getMimeType());
            }
        }
    }

    private static void setEventAttachements(CalendarEvent calendarEvent, Appointment appointment) throws Exception {
        if (appointment.getHasAttachments()) {
            Iterator attachmentIterator = appointment.getAttachments().iterator();
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            while (attachmentIterator.hasNext()) {
                microsoft.exchange.webservices.data.Attachment attachment = (microsoft.exchange.webservices.data.Attachment)attachmentIterator.next();
                if (!(attachment instanceof FileAttachment)) continue;
                FileAttachment fileAttachment = (FileAttachment)attachment;
                Attachment eXoAttachment = new Attachment();
                if (fileAttachment.getSize() == 0) continue;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                fileAttachment.load((OutputStream)outputStream);
                eXoAttachment.setInputStream((InputStream)new ByteArrayInputStream(outputStream.toByteArray()));
                eXoAttachment.setMimeType(fileAttachment.getContentType());
                eXoAttachment.setName(fileAttachment.getName());
                eXoAttachment.setSize((long)fileAttachment.getSize());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(fileAttachment.getLastModifiedTime());
                eXoAttachment.setLastModified(calendar);
                attachments.add(eXoAttachment);
            }
            calendarEvent.setAttachment(attachments);
        }
    }

    private static void setAppointmentStatus(Appointment appointment, CalendarEvent calendarEvent) throws Exception {
        String status;
        String string = status = calendarEvent.getStatus() == null || calendarEvent.getStatus().isEmpty() ? calendarEvent.getEventState() : calendarEvent.getStatus();
        if (status == null) {
            status = "";
        }
        if (status.equals(CalendarEvent.ST_AVAILABLE)) {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.Free);
        } else if (status.equals(CalendarEvent.ST_BUSY)) {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.Busy);
        } else if (status.equals(CalendarEvent.ST_OUTSIDE)) {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.OOF);
        } else {
            appointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.NoData);
        }
    }

    private static void setEventStatus(CalendarEvent calendarEvent, Appointment appointment) throws ServiceLocalException {
        if (appointment.getLegacyFreeBusyStatus() != null) {
            switch (appointment.getLegacyFreeBusyStatus()) {
                case Free: {
                    calendarEvent.setStatus(CalendarEvent.ST_AVAILABLE);
                    calendarEvent.setEventState(CalendarEvent.ST_AVAILABLE);
                    break;
                }
                case Busy: {
                    calendarEvent.setStatus(CalendarEvent.ST_BUSY);
                    calendarEvent.setEventState(CalendarEvent.ST_BUSY);
                    break;
                }
                case OOF: {
                    calendarEvent.setStatus(CalendarEvent.ST_OUTSIDE);
                    calendarEvent.setEventState(CalendarEvent.ST_OUTSIDE);
                }
            }
        }
    }

    private static void setEventReminder(CalendarEvent event, Appointment appointment, String username) throws Exception {
        ArrayList<Reminder> reminders = event.getReminders();
        if (reminders != null) {
            reminders.clear();
        }
        if (appointment.getIsReminderSet()) {
            if (reminders == null) {
                reminders = new ArrayList<Reminder>();
                event.setReminders(reminders);
            }
            Reminder reminder = new Reminder();
            reminder.setFromDateTime(appointment.getReminderDueBy());
            reminder.setAlarmBefore((long)appointment.getReminderMinutesBeforeStart());
            reminder.setDescription("");
            reminder.setEventId(event.getId());
            reminder.setReminderType(Reminder.TYPE_POPUP);
            reminder.setReminderOwner(username);
            reminder.setRepeate(false);
            reminder.setRepeatInterval((long)appointment.getReminderMinutesBeforeStart());
            reminders.add(reminder);
        }
    }

    private static EventCategory getEventCategoryByName(JCRDataStorage storage, String username, String eventCategoryName) throws Exception {
        for (EventCategory ev : storage.getEventCategories(username)) {
            if (!ev.getName().equalsIgnoreCase(eventCategoryName)) continue;
            return ev;
        }
        return null;
    }

    private static void setApoinementSummary(Appointment appointment, CalendarEvent event) throws Exception, ServiceLocalException {
        if (event.getDescription() != null && !event.getDescription().isEmpty()) {
            appointment.setBody(MessageBody.getMessageBodyFromText((String)event.getDescription()));
        }
    }

    private static void setEventDescription(CalendarEvent event, Appointment appointment) throws Exception, ServiceLocalException {
        PropertySet bodyPropSet = new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Body});
        bodyPropSet.setRequestedBodyType(BodyType.Text);
        appointment.load(bodyPropSet);
        event.setDescription(appointment.getBody().toString());
    }
}

