/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.MeetingAttendeeType;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class AttendeeInfo
implements ISelfValidate {
    private String smtpAddress;
    private MeetingAttendeeType attendeeType = MeetingAttendeeType.Required;
    private boolean excludeConflicts;

    public AttendeeInfo() {
    }

    public AttendeeInfo(String smtpAddress, MeetingAttendeeType attendeeType, boolean excludeConflicts) {
        this();
        this.smtpAddress = smtpAddress;
        this.attendeeType = attendeeType;
        this.excludeConflicts = excludeConflicts;
    }

    public AttendeeInfo(String smtpAddress) {
        this(smtpAddress, MeetingAttendeeType.Required, false);
        this.smtpAddress = smtpAddress;
    }

    public static AttendeeInfo getAttendeeInfoFromString(String smtpAddress) {
        return new AttendeeInfo(smtpAddress);
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, "MailboxData");
        writer.writeStartElement(XmlNamespace.Types, "Email");
        writer.writeElementValue(XmlNamespace.Types, "Address", this.smtpAddress);
        writer.writeEndElement();
        writer.writeElementValue(XmlNamespace.Types, "AttendeeType", (Object)this.attendeeType);
        writer.writeElementValue(XmlNamespace.Types, "ExcludeConflicts", this.excludeConflicts);
        writer.writeEndElement();
    }

    public String getSmtpAddress() {
        return this.smtpAddress;
    }

    public void setSmtpAddress(String smtpAddress) {
        this.smtpAddress = smtpAddress;
    }

    public MeetingAttendeeType getAttendeeType() {
        return this.attendeeType;
    }

    public void setAttendeeType(MeetingAttendeeType attendeeType) {
        this.attendeeType = attendeeType;
    }

    public boolean isExcludeConflicts() {
        return this.excludeConflicts;
    }

    public void setExcludeConflicts(boolean excludeConflicts) {
        this.excludeConflicts = excludeConflicts;
    }

    public void validate() throws Exception {
        EwsUtilities.validateParam(this.smtpAddress, "SmtpAddress");
    }
}

