/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.ComplexFunctionDelegate;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ComplexProperty
implements ISelfValidate,
ComplexFunctionDelegate {
    private XmlNamespace xmlNamespace = XmlNamespace.Types;
    private List<IComplexPropertyChangedDelegate> onChangeList = new ArrayList<IComplexPropertyChangedDelegate>();

    protected ComplexProperty() {
    }

    protected XmlNamespace getNamespace() {
        return this.xmlNamespace;
    }

    protected void setNamespace(XmlNamespace xmlNamespace) {
        this.xmlNamespace = xmlNamespace;
    }

    protected void changed() {
        if (!this.onChangeList.isEmpty()) {
            for (IComplexPropertyChangedDelegate change : this.onChangeList) {
                change.complexPropertyChanged(this);
            }
        }
    }

    protected <T> boolean canSetFieldValue(T field, T value) {
        boolean applyChange;
        if (field == null) {
            applyChange = value != null;
        } else if (field instanceof Comparable) {
            Comparable c = (Comparable)field;
            applyChange = value != null ? c.compareTo(value) != 0 : false;
        } else {
            applyChange = true;
        }
        return applyChange;
    }

    protected void clearChangeLog() {
    }

    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
    }

    protected void readTextValueFromXml(EwsServiceXmlReader reader) throws Exception {
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        return false;
    }

    protected boolean tryReadElementFromXmlToPatch(EwsServiceXmlReader reader) throws Exception {
        return false;
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
    }

    protected void loadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        this.internalLoadFromXml(reader, xmlNamespace, xmlElementName, false);
    }

    protected void updateFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        this.updateFromXml(reader, this.getNamespace(), xmlElementName);
    }

    protected void updateFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        this.internalupdateLoadFromXml(reader, xmlNamespace, xmlElementName, false);
    }

    private void internalLoadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName, boolean readValue) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, xmlElementName);
        this.readAttributesFromXml(reader);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                switch (reader.getNodeType().nodeType) {
                    case 1: {
                        if (this.tryReadElementFromXml(reader)) break;
                        reader.skipCurrentElement();
                        break;
                    }
                    case 4: {
                        this.readTextValueFromXml(reader);
                    }
                }
            } while (!reader.isEndElement(xmlNamespace, xmlElementName));
        } else {
            reader.read();
            reader.isEndElement(xmlNamespace, xmlElementName);
        }
    }

    private void internalupdateLoadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName, boolean readValue) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, xmlElementName);
        this.readAttributesFromXml(reader);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                switch (reader.getNodeType().nodeType) {
                    case 1: {
                        if (this.tryReadElementFromXmlToPatch(reader)) break;
                        reader.skipCurrentElement();
                        break;
                    }
                    case 4: {
                        this.readTextValueFromXml(reader);
                    }
                }
            } while (!reader.isEndElement(xmlNamespace, xmlElementName));
        }
    }

    protected void loadFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        this.loadFromXml(reader, this.getNamespace(), xmlElementName);
    }

    protected void writeToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        writer.writeStartElement(xmlNamespace, xmlElementName);
        this.writeAttributesToXml(writer);
        this.writeElementsToXml(writer);
        writer.writeEndElement();
    }

    protected void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws Exception {
        this.writeToXml(writer, this.getNamespace(), xmlElementName);
    }

    protected void addOnChangeEvent(IComplexPropertyChangedDelegate change) {
        this.onChangeList.add(change);
    }

    protected void removeChangeEvent(IComplexPropertyChangedDelegate change) {
        this.onChangeList.remove(change);
    }

    protected void clearChangeEvents() {
        this.onChangeList.clear();
    }

    @Override
    public void validate() throws ServiceValidationException, Exception {
        this.internalValidate();
    }

    protected void internalValidate() throws ServiceValidationException, Exception {
    }

    public Boolean func(EwsServiceXmlReader reader) throws Exception {
        if (!this.tryReadElementFromXml(reader)) {
            return true;
        }
        return false;
    }
}

