/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import microsoft.exchange.webservices.data.DelegateUser;
import microsoft.exchange.webservices.data.DelegateUserResponse;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.ServiceError;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelegateManagementResponse
extends ServiceResponse {
    private boolean readDelegateUsers;
    private List<DelegateUser> delegateUsers;
    private Collection<DelegateUserResponse> delegateUserResponses;

    protected DelegateManagementResponse(boolean readDelegateUsers, List<DelegateUser> delegateUsers) {
        this.readDelegateUsers = readDelegateUsers;
        this.delegateUsers = delegateUsers;
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        if (this.getErrorCode() == ServiceError.NoError) {
            this.delegateUserResponses = new ArrayList<DelegateUserResponse>();
            reader.read();
            if (reader.isStartElement(XmlNamespace.Messages, "ResponseMessages")) {
                int delegateUserIndex = 0;
                do {
                    reader.read();
                    if (!reader.isStartElement(XmlNamespace.Messages, "DelegateUserResponseMessageType")) continue;
                    DelegateUser delegateUser = null;
                    if (this.readDelegateUsers && this.delegateUsers != null) {
                        delegateUser = this.delegateUsers.get(delegateUserIndex);
                    }
                    DelegateUserResponse delegateUserResponse = new DelegateUserResponse(this.readDelegateUsers, delegateUser);
                    delegateUserResponse.loadFromXml(reader, "DelegateUserResponseMessageType");
                    this.delegateUserResponses.add(delegateUserResponse);
                    ++delegateUserIndex;
                } while (!reader.isEndElement(XmlNamespace.Messages, "ResponseMessages"));
            }
        }
    }

    protected Collection<DelegateUserResponse> getDelegateUserResponses() {
        return this.delegateUserResponses;
    }
}

