/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.MapiTypeConverter;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.StringList;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class ExtendedProperty
extends ComplexProperty {
    private ExtendedPropertyDefinition propertyDefinition;
    private Object value;

    protected ExtendedProperty() {
    }

    protected ExtendedProperty(ExtendedPropertyDefinition propertyDefinition) throws Exception {
        this();
        EwsUtilities.validateParam(propertyDefinition, "propertyDefinition");
        this.propertyDefinition = propertyDefinition;
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("ExtendedFieldURI")) {
            this.propertyDefinition = new ExtendedPropertyDefinition();
            this.propertyDefinition.loadFromXml(reader);
            return true;
        }
        if (reader.getLocalName().equals("Value")) {
            EwsUtilities.EwsAssert(this.getPropertyDefinition() != null, "ExtendedProperty.TryReadElementFromXml", "PropertyDefintion is missing");
            String stringValue = reader.readElementValue();
            this.value = MapiTypeConverter.convertToValue(this.getPropertyDefinition().getMapiType(), stringValue);
            return true;
        }
        if (reader.getLocalName().equals("Values")) {
            EwsUtilities.EwsAssert(this.getPropertyDefinition() != null, "ExtendedProperty.TryReadElementFromXml", "PropertyDefintion is missing");
            StringList stringList = new StringList("Value");
            stringList.loadFromXml(reader, reader.getLocalName());
            this.value = MapiTypeConverter.convertToValue(this.getPropertyDefinition().getMapiType(), stringList.iterator());
            return true;
        }
        return false;
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        this.getPropertyDefinition().writeToXml(writer);
        if (MapiTypeConverter.isArrayType(this.getPropertyDefinition().getMapiType())) {
            ArrayList array = (ArrayList)this.getValue();
            writer.writeStartElement(XmlNamespace.Types, "Values");
            for (int index = 0; index <= array.size(); ++index) {
                writer.writeElementValue(XmlNamespace.Types, "Value", MapiTypeConverter.convertToString(this.getPropertyDefinition().getMapiType(), array.get(index)));
            }
            writer.writeEndElement();
        } else {
            writer.writeElementValue(XmlNamespace.Types, "Value", MapiTypeConverter.convertToString(this.getPropertyDefinition().getMapiType(), this.getValue()));
        }
    }

    public ExtendedPropertyDefinition getPropertyDefinition() {
        return this.propertyDefinition;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) throws Exception {
        EwsUtilities.validateParam(val, "value");
        if (this.canSetFieldValue(this.value, MapiTypeConverter.changeType(this.getPropertyDefinition().getMapiType(), val))) {
            this.value = MapiTypeConverter.changeType(this.getPropertyDefinition().getMapiType(), val);
            this.changed();
        }
    }

    private String getStringValue() {
        if (MapiTypeConverter.isArrayType(this.getPropertyDefinition().getMapiType())) {
            ArrayList array = (ArrayList)this.getValue();
            if (array == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int index = 0; index <= array.size(); ++index) {
                sb.append(MapiTypeConverter.convertToString(this.getPropertyDefinition().getMapiType(), array.get(index)));
                sb.append(",");
            }
            sb.append("]");
            return sb.toString();
        }
        return MapiTypeConverter.convertToString(this.getPropertyDefinition().getMapiType(), this.getValue());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExtendedProperty) {
            ExtendedProperty other = (ExtendedProperty)obj;
            if (other.getPropertyDefinition().equals(this.getPropertyDefinition())) {
                return this.getStringValue().equals(other.getStringValue());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        String printableName = this.getPropertyDefinition() != null ? this.getPropertyDefinition().getPrintableName() : "";
        String stringVal = this.getStringValue();
        return (printableName + stringVal).hashCode();
    }
}

