/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.AbstractFolderIdWrapper;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.FolderIdWrapper;
import microsoft.exchange.webservices.data.FolderWrapper;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FolderIdWrapperList
implements Iterable<AbstractFolderIdWrapper> {
    private List<AbstractFolderIdWrapper> ids = new ArrayList<AbstractFolderIdWrapper>();

    FolderIdWrapperList() {
    }

    protected void add(Folder folder) throws ServiceLocalException {
        this.ids.add(new FolderWrapper(folder));
    }

    protected void addRangeFolder(Iterable<Folder> folders) throws ServiceLocalException {
        if (folders != null) {
            for (Folder folder : folders) {
                this.add(folder);
            }
        }
    }

    protected void add(FolderId folderId) {
        this.ids.add(new FolderIdWrapper(folderId));
    }

    protected void addRangeFolderId(Iterable<FolderId> folderIds) {
        if (folderIds != null) {
            for (FolderId folderId : folderIds) {
                this.add(folderId);
            }
        }
    }

    protected void writeToXml(EwsServiceXmlWriter writer, XmlNamespace ewsNamesapce, String xmlElementName) throws Exception {
        if (this.getCount() > 0) {
            writer.writeStartElement(ewsNamesapce, xmlElementName);
            for (AbstractFolderIdWrapper folderIdWrapper : this.ids) {
                folderIdWrapper.writeToXml(writer);
            }
            writer.writeEndElement();
        }
    }

    protected int getCount() {
        return this.ids.size();
    }

    protected AbstractFolderIdWrapper getFolderIdWrapperList(int i) {
        return this.ids.get(i);
    }

    protected void validate(ExchangeVersion version) throws ServiceVersionException {
        for (AbstractFolderIdWrapper folderIdWrapper : this.ids) {
            folderIdWrapper.validate(version);
        }
    }

    @Override
    public Iterator<AbstractFolderIdWrapper> iterator() {
        return this.ids.iterator();
    }
}

