/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetEventsResponse;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetEventsRequest
extends MultiResponseServiceRequest<GetEventsResponse> {
    private String subscriptionId;
    private String watermark;

    protected GetEventsRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected GetEventsResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new GetEventsResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "GetEvents";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetEventsResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetEventsResponseMessage";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateNonBlankStringParam(this.getSubscriptionId(), "SubscriptionId");
        EwsUtilities.validateNonBlankStringParam(this.getWatermark(), "Watermark");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Messages, "SubscriptionId", this.getSubscriptionId());
        writer.writeElementValue(XmlNamespace.Messages, "Watermark", this.getWatermark());
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getWatermark() {
        return this.watermark;
    }

    public void setWatermark(String watermark) {
        this.watermark = watermark;
    }
}

