/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.NameResolution;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameResolutionCollection
implements Iterable<NameResolution> {
    private ExchangeService service;
    private boolean includesAllResolutions;
    private List<NameResolution> items = new ArrayList<NameResolution>();

    protected NameResolutionCollection(ExchangeService service) {
        EwsUtilities.EwsAssert(service != null, "NameResolutionSet.ctor", "service is null.");
        this.service = service;
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "ResolutionSet");
        int totalItemsInView = reader.readAttributeValue(Integer.class, "TotalItemsInView");
        this.includesAllResolutions = reader.readAttributeValue(Boolean.class, "IncludesLastItemInRange");
        for (int i = 0; i < totalItemsInView; ++i) {
            NameResolution nameResolution = new NameResolution(this);
            nameResolution.loadFromXml(reader);
            this.items.add(nameResolution);
        }
        reader.readEndElement(XmlNamespace.Messages, "ResolutionSet");
    }

    protected ExchangeService getSession() {
        return this.service;
    }

    public int getCount() {
        return this.items.size();
    }

    public boolean getIncludesAllResolutions() {
        return this.includesAllResolutions;
    }

    public NameResolution nameResolutionCollection(int index) throws ArgumentOutOfRangeException {
        if (index < 0 || index >= this.getCount()) {
            throw new ArgumentOutOfRangeException("index", Strings.IndexIsOutOfRange);
        }
        return this.items.get(index);
    }

    @Override
    public Iterator<NameResolution> iterator() {
        return this.items.iterator();
    }
}

