/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectPropertyDefinition;
import microsoft.exchange.webservices.data.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyDefinition
extends ServiceObjectPropertyDefinition {
    private String xmlElementName;
    private EnumSet<PropertyDefinitionFlags> flags;
    private String name;
    private ExchangeVersion version;

    protected PropertyDefinition(String xmlElementName, String uri, ExchangeVersion version) {
        super(uri);
        this.xmlElementName = xmlElementName;
        this.flags = EnumSet.of(PropertyDefinitionFlags.None);
        this.version = version;
    }

    protected PropertyDefinition(String xmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        this.xmlElementName = xmlElementName;
        this.flags = flags;
        this.version = version;
    }

    protected PropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        this(xmlElementName, uri, version);
        this.flags = flags;
    }

    protected boolean hasFlag(PropertyDefinitionFlags flag) {
        return this.hasFlag(flag, null);
    }

    protected boolean hasFlag(PropertyDefinitionFlags flag, ExchangeVersion version) {
        return this.flags.contains((Object)flag);
    }

    protected void registerAssociatedInternalProperties(List<PropertyDefinition> properties) {
    }

    protected List<PropertyDefinition> getAssociatedInternalProperties() {
        ArrayList<PropertyDefinition> properties = new ArrayList<PropertyDefinition>();
        this.registerAssociatedInternalProperties(properties);
        return properties;
    }

    @Override
    public ExchangeVersion getVersion() {
        return this.version;
    }

    protected boolean isNullable() {
        return true;
    }

    protected abstract void loadPropertyValueFromXml(EwsServiceXmlReader var1, PropertyBag var2) throws ServiceXmlDeserializationException, XMLStreamException, InstantiationException, IllegalAccessException, ServiceObjectPropertyException, ServiceVersionException, Exception;

    protected abstract void writePropertyValueToXml(EwsServiceXmlWriter var1, PropertyBag var2, boolean var3) throws XMLStreamException, ServiceXmlSerializationException, ServiceLocalException, InstantiationException, IllegalAccessException, ServiceValidationException, Exception;

    protected String getXmlElement() {
        return this.xmlElementName;
    }

    public String getName() {
        if (null == this.name || this.name.isEmpty()) {
            ServiceObjectSchema.initializeSchemaPropertyNames();
        }
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    protected String getPrintableName() {
        return this.getName();
    }
}

