/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ServiceError;
import microsoft.exchange.webservices.data.ServiceRemoteException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.Strings;

public class ServiceResponseException
extends ServiceRemoteException {
    private static final String ExceptionClassKey = "ExceptionClass";
    private static final String ExceptionMessageKey = "ExceptionMessage";
    private static final String StackTraceKey = "StackTrace";
    private ServiceResponse response;

    protected ServiceResponseException(ServiceResponse response) {
        this.response = response;
    }

    public ServiceResponse getResponse() {
        return this.response;
    }

    public ServiceError getErrorCode() {
        return this.response.getErrorCode();
    }

    public String getMessage() {
        if (this.response.getErrorCode() == ServiceError.ErrorInternalServerError && this.response.getErrorDetails().containsKey(ExceptionClassKey) && this.response.getErrorDetails().containsKey(ExceptionMessageKey) && this.response.getErrorDetails().containsKey(StackTraceKey)) {
            String exceptionClass = this.response.getErrorDetails().get(ExceptionClassKey);
            String exceptionMessage = this.response.getErrorDetails().get(ExceptionMessageKey);
            String stackTrace = this.response.getErrorDetails().get(StackTraceKey);
            return String.format(Strings.ServerErrorAndStackTraceDetails, this.response.getErrorMessage(), exceptionClass, exceptionMessage, stackTrace);
        }
        return this.response.getErrorMessage();
    }
}

