/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.StandardUser;
import microsoft.exchange.webservices.data.XmlNamespace;

public class UserId
extends ComplexProperty {
    private String sID;
    private String primarySmtpAddress;
    private String displayName;
    private StandardUser standardUser;

    public UserId() {
    }

    public UserId(String primarySmtpAddress) {
        this.primarySmtpAddress = primarySmtpAddress;
    }

    public UserId(StandardUser standardUser) {
        this();
        this.standardUser = standardUser;
    }

    protected boolean isValid() {
        return this.standardUser != null || this.primarySmtpAddress != null && !this.primarySmtpAddress.isEmpty() || this.sID != null && !this.sID.isEmpty();
    }

    public String getSID() {
        return this.sID;
    }

    public void setSID(String sID) {
        if (this.canSetFieldValue(this.sID, sID)) {
            this.sID = sID;
            this.changed();
        }
    }

    public String getPrimarySmtpAddress() {
        return this.primarySmtpAddress;
    }

    public void setPrimarySmtpAddress(String primarySmtpAddress) {
        if (this.canSetFieldValue(this.primarySmtpAddress, primarySmtpAddress)) {
            this.primarySmtpAddress = primarySmtpAddress;
            this.changed();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        if (this.canSetFieldValue(this.displayName, displayName)) {
            this.displayName = displayName;
            this.changed();
        }
    }

    public StandardUser getstandardUser() {
        return this.standardUser;
    }

    public void setStandardUser(StandardUser standardUser) {
        if (this.canSetFieldValue(this.standardUser, standardUser)) {
            this.standardUser = standardUser;
            this.changed();
        }
    }

    public static UserId getUserId(String primarySmtpAddress) {
        return new UserId(primarySmtpAddress);
    }

    public static UserId getUserIdFromStandardUser(StandardUser standardUser) {
        return new UserId(standardUser);
    }

    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("SID")) {
            this.sID = reader.readValue();
            return true;
        }
        if (reader.getLocalName().equals("PrimarySmtpAddress")) {
            this.primarySmtpAddress = reader.readValue();
            return true;
        }
        if (reader.getLocalName().equals("DisplayName")) {
            this.displayName = reader.readValue();
            return true;
        }
        if (reader.getLocalName().equals("DistinguishedUser")) {
            this.standardUser = reader.readValue(StandardUser.class);
            return true;
        }
        return false;
    }

    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Types, "SID", this.sID);
        writer.writeElementValue(XmlNamespace.Types, "PrimarySmtpAddress", this.primarySmtpAddress);
        writer.writeElementValue(XmlNamespace.Types, "DisplayName", this.displayName);
        writer.writeElementValue(XmlNamespace.Types, "DistinguishedUser", (Object)this.standardUser);
    }
}

