/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.DelegateManagementResponse;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.Mailbox;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DelegateManagementRequestBase<TResponse extends DelegateManagementResponse>
extends SimpleServiceRequestBase {
    private Mailbox mailbox;

    protected DelegateManagementRequestBase(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParam(this.getMailbox(), "Mailbox");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getMailbox().writeToXml(writer, XmlNamespace.Messages, "Mailbox");
    }

    protected abstract TResponse createResponse();

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        TResponse response = this.createResponse();
        ((ServiceResponse)response).loadFromXml(reader, this.getResponseXmlElementName());
        return response;
    }

    protected TResponse execute() throws Exception {
        DelegateManagementResponse serviceResponse = (DelegateManagementResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return (TResponse)serviceResponse;
    }

    public Mailbox getMailbox() {
        return this.mailbox;
    }

    public void setMailbox(Mailbox mailbox) {
        this.mailbox = mailbox;
    }
}

