/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;

public abstract class ServiceId
extends ComplexProperty {
    private String changeKey;
    private String uniqueId;

    protected ServiceId() {
    }

    protected ServiceId(String uniqueId) throws Exception {
        this();
        EwsUtilities.validateParam(uniqueId, "uniqueId");
        this.uniqueId = uniqueId;
    }

    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.uniqueId = reader.readAttributeValue("Id");
        this.changeKey = reader.readAttributeValue("ChangeKey");
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Id", this.getUniqueId());
        writer.writeAttributeValue("ChangeKey", this.getChangeKey());
    }

    protected abstract String getXmlElementName();

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writeToXml(writer, this.getXmlElementName());
    }

    protected void assign(ServiceId source) {
        this.uniqueId = source.getUniqueId();
        this.changeKey = source.getChangeKey();
    }

    protected boolean isValid() {
        return null != this.uniqueId && !this.uniqueId.isEmpty();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    protected void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getChangeKey() {
        return this.changeKey;
    }

    protected void setChangeKey(String changeKey) {
        this.changeKey = changeKey;
    }

    public boolean sameIdAndChangeKey(ServiceId other) {
        if (this.equals(other)) {
            return this.getChangeKey() == null && other.getChangeKey() == null || this.getChangeKey().equals(other.getChangeKey());
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof ServiceId)) {
            return false;
        }
        ServiceId other = (ServiceId)obj;
        if (!this.isValid() || !other.isValid()) {
            return false;
        }
        return this.getUniqueId().equals(other.getUniqueId());
    }

    public int hashCode() {
        return this.isValid() ? this.getUniqueId().hashCode() : super.hashCode();
    }

    public String toString() {
        return this.uniqueId == null ? "" : this.uniqueId;
    }
}

