/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.IndexedPropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.ServiceError;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObjectSchema;
import microsoft.exchange.webservices.data.ServiceResponseException;
import microsoft.exchange.webservices.data.ServiceResult;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.SoapFaultDetails;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceResponse {
    private ServiceResult result;
    private ServiceError errorCode;
    private String errorMessage;
    private Map<String, String> errorDetails = new HashMap<String, String>();
    private Collection<PropertyDefinitionBase> errorProperties = new ArrayList<PropertyDefinitionBase>();

    protected ServiceResponse() {
    }

    protected ServiceResponse(SoapFaultDetails soapFaultDetails) {
        this.result = ServiceResult.Error;
        this.errorCode = soapFaultDetails.getResponseCode();
        this.errorMessage = soapFaultDetails.getFaultString();
        this.errorDetails = soapFaultDetails.getErrorDetails();
    }

    protected void loadFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        if (!reader.isStartElement(XmlNamespace.Messages, xmlElementName)) {
            reader.readStartElement(XmlNamespace.Messages, xmlElementName);
        }
        this.result = reader.readAttributeValue(ServiceResult.class, "ResponseClass");
        if (this.result == ServiceResult.Success || this.result == ServiceResult.Warning) {
            if (this.result == ServiceResult.Warning) {
                this.errorMessage = reader.readElementValue(XmlNamespace.Messages, "MessageText");
            }
            this.errorCode = reader.readElementValue(ServiceError.class, XmlNamespace.Messages, "ResponseCode");
            if (this.result == ServiceResult.Warning) {
                reader.readElementValue(Integer.TYPE, XmlNamespace.Messages, "DescriptiveLinkKey");
            }
            if (this.getBatchProcessingStopped()) {
                do {
                    reader.read();
                } while (!reader.isEndElement(XmlNamespace.Messages, xmlElementName));
            } else {
                this.readElementsFromXml(reader);
                if (reader.isEmptyElement()) {
                    reader.read();
                }
                reader.readEndElementIfNecessary(XmlNamespace.Messages, xmlElementName);
            }
        } else {
            this.errorMessage = reader.readElementValue(XmlNamespace.Messages, "MessageText");
            this.errorCode = reader.readElementValue(ServiceError.class, XmlNamespace.Messages, "ResponseCode");
            reader.readElementValue(Integer.TYPE, XmlNamespace.Messages, "DescriptiveLinkKey");
            while (!reader.isEndElement(XmlNamespace.Messages, xmlElementName)) {
                reader.read();
                if (!reader.isStartElement() || this.loadExtraErrorDetailsFromXml(reader, reader.getLocalName())) continue;
                reader.skipCurrentElement();
            }
        }
        this.mapErrorCodeToErrorMessage();
        this.loaded();
    }

    protected void parseMessageXml(EwsServiceXmlReader reader) throws Exception {
        do {
            reader.read();
            if (!reader.isStartElement()) continue;
            if (reader.getLocalName().equals("Value")) {
                this.errorDetails.put(reader.readAttributeValue("Name"), reader.readElementValue());
                continue;
            }
            if (reader.getLocalName().equals("FieldURI")) {
                this.errorProperties.add(ServiceObjectSchema.findPropertyDefinition(reader.readAttributeValue("FieldURI")));
                continue;
            }
            if (reader.getLocalName().equals("IndexedFieldURI")) {
                this.errorProperties.add(new IndexedPropertyDefinition(reader.readAttributeValue("FieldURI"), reader.readAttributeValue("FieldIndex")));
                continue;
            }
            if (!reader.getLocalName().equals("ExtendedFieldURI")) continue;
            ExtendedPropertyDefinition extendedPropDef = new ExtendedPropertyDefinition();
            extendedPropDef.loadFromXml(reader);
            this.errorProperties.add(extendedPropDef);
        } while (!reader.isEndElement(XmlNamespace.Messages, "MessageXml"));
    }

    protected void loaded() {
    }

    protected void mapErrorCodeToErrorMessage() {
        if (this.getErrorCode() == ServiceError.ErrorIrresolvableConflict) {
            this.setErrorMessage(Strings.ItemIsOutOfDate);
        }
    }

    protected void readElementsFromXml(EwsServiceXmlReader reader) throws ServiceXmlDeserializationException, XMLStreamException, InstantiationException, IllegalAccessException, ServiceLocalException, Exception {
    }

    protected boolean loadExtraErrorDetailsFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        if (reader.isStartElement(XmlNamespace.Messages, "MessageXml") && !reader.isEmptyElement()) {
            this.parseMessageXml(reader);
            return true;
        }
        return false;
    }

    protected void throwIfNecessary() throws ServiceResponseException {
        this.internalThrowIfNecessary();
    }

    protected void internalThrowIfNecessary() throws ServiceResponseException {
        if (this.result == ServiceResult.Error) {
            throw new ServiceResponseException(this);
        }
    }

    protected boolean getBatchProcessingStopped() {
        return this.result == ServiceResult.Warning && this.errorCode == ServiceError.ErrorBatchProcessingStopped;
    }

    public ServiceResult getResult() {
        return this.result;
    }

    public ServiceError getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Map<String, String> getErrorDetails() {
        return this.errorDetails;
    }

    public Collection<PropertyDefinitionBase> getErrorProperties() {
        return this.errorProperties;
    }
}

