/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.ConflictResolutionMode;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UpdateItemResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UpdateItemRequest
extends MultiResponseServiceRequest<UpdateItemResponse> {
    private List<Item> items = new ArrayList<Item>();
    private FolderId savedItemsDestinationFolder;
    private ConflictResolutionMode conflictResolutionMode;
    private MessageDisposition messageDisposition;
    private SendInvitationsOrCancellationsMode sendInvitationsOrCancellationsMode;

    protected UpdateItemRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getItems().iterator(), "Items");
        for (int i = 0; i < this.getItems().size(); ++i) {
            if (this.getItems().get(i) != null && !this.getItems().get(i).isNew()) continue;
            throw new ArgumentException(String.format(Strings.ItemToUpdateCannotBeNullOrNew, i));
        }
        if (this.savedItemsDestinationFolder != null) {
            this.savedItemsDestinationFolder.validate(this.getService().getRequestedServerVersion());
        }
        for (Item item : this.getItems()) {
            item.validate();
        }
    }

    @Override
    protected UpdateItemResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new UpdateItemResponse(this.getItems().get(responseIndex));
    }

    @Override
    protected String getXmlElementName() {
        return "UpdateItem";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateItemResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "UpdateItemResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.items.size();
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        if (this.messageDisposition != null) {
            writer.writeAttributeValue("MessageDisposition", (Object)this.messageDisposition);
        }
        writer.writeAttributeValue("ConflictResolution", (Object)this.conflictResolutionMode);
        if (this.sendInvitationsOrCancellationsMode != null) {
            writer.writeAttributeValue("SendMeetingInvitationsOrCancellations", (Object)this.sendInvitationsOrCancellationsMode);
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.savedItemsDestinationFolder != null) {
            writer.writeStartElement(XmlNamespace.Messages, "SavedItemFolderId");
            this.savedItemsDestinationFolder.writeToXml(writer);
            writer.writeEndElement();
        }
        writer.writeStartElement(XmlNamespace.Messages, "ItemChanges");
        for (Item item : this.items) {
            item.writeToXmlForUpdate(writer);
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public MessageDisposition getMessageDisposition() {
        return this.messageDisposition;
    }

    public void setMessageDisposition(MessageDisposition value) {
        this.messageDisposition = value;
    }

    public ConflictResolutionMode getConflictResolutionMode() {
        return this.conflictResolutionMode;
    }

    public void setConflictResolutionMode(ConflictResolutionMode value) {
        this.conflictResolutionMode = value;
    }

    public SendInvitationsOrCancellationsMode getSendInvitationsOrCancellationsMode() {
        return this.sendInvitationsOrCancellationsMode;
    }

    public void setSendInvitationsOrCancellationsMode(SendInvitationsOrCancellationsMode value) {
        this.sendInvitationsOrCancellationsMode = value;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public FolderId getSavedItemsDestinationFolder() {
        return this.savedItemsDestinationFolder;
    }

    public void setSavedItemsDestinationFolder(FolderId value) {
        this.savedItemsDestinationFolder = value;
    }
}

