/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.extension.exchange.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.service.ConflictResolutionMode;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendInvitationsOrCancellationsMode;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.extension.exchange.service.CorrespondenceService;
import org.exoplatform.extension.exchange.service.util.CalendarConverterUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;

public class ExchangeStorageService
implements Serializable {
    private static final long serialVersionUID = 6348129698208975430L;
    private static final Log LOG = ExoLogger.getLogger(ExchangeStorageService.class);
    private OrganizationService organizationService;
    private CorrespondenceService correspondenceService;

    public ExchangeStorageService(OrganizationService organizationService, CorrespondenceService correspondenceService) {
        this.organizationService = organizationService;
        this.correspondenceService = correspondenceService;
    }

    public List<FolderId> getAllExchangeCalendars(ExchangeService service) throws Exception {
        ArrayList<FolderId> calendarFolderIds = new ArrayList<FolderId>();
        CalendarFolder calendarRootFolder = CalendarFolder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.Calendar);
        calendarFolderIds.add(calendarRootFolder.getId());
        List<Folder> calendarfolders = this.searchSubFolders(service, calendarRootFolder.getId());
        if (calendarfolders != null && !calendarfolders.isEmpty()) {
            for (Folder tmpFolder : calendarfolders) {
                calendarFolderIds.add(tmpFolder.getId());
            }
        }
        return calendarFolderIds;
    }

    public boolean updateOrCreateExchangeAppointment(String username, ExchangeService service, CalendarEvent event, String exoMasterId, Function<Appointment, Boolean> appointmentSavedCallback) throws Exception {
        if (event == null) {
            return false;
        }
        String folderIdString = this.correspondenceService.getCorrespondingId(username, event.getCalendarId());
        if (folderIdString == null || folderIdString.isEmpty()) {
            LOG.trace("eXo Calendar with id '{}' is not synhronized with Exchange, ignore Event: {}", new Object[]{event.getCalendarId(), event.getSummary()});
            return false;
        }
        String itemId = this.correspondenceService.getCorrespondingId(username, event.getId());
        boolean isNew = true;
        Appointment appointment = null;
        if (itemId != null) {
            try {
                appointment = Appointment.bind((ExchangeService)service, (ItemId)ItemId.getItemIdFromString((String)itemId));
                isNew = appointment == null;
            }
            catch (ServiceResponseException e) {
                LOG.warn((Object)("Item was not bound, it was deleted or not yet created:" + event.getId()), (Throwable)e);
                this.correspondenceService.deleteCorrespondingId(username, event.getId());
            }
        }
        if (!isNew && appointment.getLastModifiedTime() != null && appointment.getLastModifiedTime().getTime() == event.getLastModified()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("IGNORE updating appointment '{}' because its modified date is same as event modified date", new Object[]{event.getSummary()});
            }
            return false;
        }
        if (event.getRecurrenceId() == null && (event.getRepeatType() == null || event.getRepeatType().equals(CalendarEvent.RP_NOREPEAT))) {
            if (isNew) {
                if (CalendarConverterUtils.isExchangeEventId(event.getId())) {
                    LOG.error((Object)"Conflict in modification, inconsistant data, the event was deleted in Exchange but seems always in eXo, the event will be deleted from Exchange.");
                    this.deleteAppointmentByExoEventId(username, service, event.getId(), event.getCalendarId());
                    return false;
                }
                appointment = new Appointment(service);
            }
            CalendarConverterUtils.convertExoToExchangeEvent(appointment, event, username, this.organizationService.getUserHandler());
        } else if (event.getRecurrenceId() != null && !event.getRecurrenceId().isEmpty() || event.getIsExceptionOccurrence() != null && event.getIsExceptionOccurrence().booleanValue()) {
            if (isNew) {
                String exchangeMasterId = this.correspondenceService.getCorrespondingId(username, exoMasterId);
                if (StringUtils.isNotBlank((CharSequence)exchangeMasterId) && (appointment = this.getAppointmentOccurence(service, exchangeMasterId, event.getRecurrenceId())) != null) {
                    this.correspondenceService.setCorrespondingId(username, event.getId(), appointment.getId().getUniqueId());
                    isNew = false;
                }
                if (isNew) {
                    appointment = new Appointment(service);
                }
            }
            CalendarConverterUtils.convertExoToExchangeOccurenceEvent(appointment, event, username, this.organizationService.getUserHandler());
        } else {
            List<Appointment> toDeleteOccurences;
            if (isNew) {
                if (CalendarConverterUtils.isExchangeEventId(event.getId())) {
                    LOG.error((Object)"Conflict in modification, inconsistant data, the event was deleted in Exchange but seems always in eXo, the event will be deleted from Exchange.");
                    this.deleteAppointmentByExoEventId(username, service, event.getId(), event.getCalendarId());
                    return false;
                }
                appointment = new Appointment(service);
            }
            if ((toDeleteOccurences = CalendarConverterUtils.convertExoToExchangeMasterRecurringCalendarEvent(appointment, event, username, this.organizationService.getUserHandler())) != null && !toDeleteOccurences.isEmpty()) {
                for (Appointment occAppointment : toDeleteOccurences) {
                    CalendarServiceImpl calendarService = (CalendarServiceImpl)PortalContainer.getInstance().getComponentInstanceOfType(CalendarService.class);
                    CalendarEvent tmpEvent = CalendarConverterUtils.getOccurenceOfDate(username, calendarService.getDataStorage(), event, occAppointment.getOriginalStart());
                    if (tmpEvent != null) {
                        CalendarConverterUtils.convertExoToExchangeOccurenceEvent(occAppointment, tmpEvent, username, this.organizationService.getUserHandler());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("CREATE Exchange Exceptional Occurence Appointment: " + tmpEvent.getSummary()));
                        }
                        try {
                            occAppointment.update(ConflictResolutionMode.AlwaysOverwrite);
                        }
                        catch (ServiceResponseException e) {
                            if (e.getMessage() != null && e.getMessage().contains("At least one recipient isn't valid")) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.warn((Object)"Error while saving appointment", (Throwable)e);
                                }
                                occAppointment.update(ConflictResolutionMode.AlwaysOverwrite, SendInvitationsOrCancellationsMode.SendToNone);
                            }
                            throw e;
                        }
                        this.correspondenceService.setCorrespondingId(username, tmpEvent.getId(), occAppointment.getId().getUniqueId());
                        appointmentSavedCallback.apply(occAppointment);
                        continue;
                    }
                    String exoId = this.correspondenceService.getCorrespondingId(username, occAppointment.getId().getUniqueId());
                    if (exoId != null) continue;
                    this.deleteAppointment(username, service, occAppointment.getId());
                }
            }
        }
        if (isNew) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("CREATE Exchange Appointment: " + event.getSummary()));
            }
            FolderId folderId = FolderId.getFolderIdFromString((String)folderIdString);
            try {
                appointment.save(folderId);
            }
            catch (ServiceResponseException e) {
                if (e.getMessage() != null && e.getMessage().contains("At least one recipient isn't valid")) {
                    if (LOG.isTraceEnabled()) {
                        LOG.warn((Object)"Error while saving appointment", (Throwable)e);
                    }
                    appointment.save(folderId, SendInvitationsMode.SendToNone);
                }
                throw e;
            }
            this.correspondenceService.setCorrespondingId(username, event.getId(), appointment.getId().getUniqueId());
            appointmentSavedCallback.apply(appointment);
        } else {
            if (this.getLastModifiedDate(appointment).getTime() == event.getLastModified()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IGNORE UPDATE Exchange Appointment '{}' because its modified date is the same as eXo Event", new Object[]{event.getSummary()});
                }
                return false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("UPDATE Exchange Appointment: " + event.getSummary()));
            }
            try {
                appointment.update(ConflictResolutionMode.AlwaysOverwrite);
            }
            catch (ServiceResponseException e) {
                if (e.getMessage() != null && e.getMessage().contains("At least one recipient isn't valid")) {
                    if (LOG.isTraceEnabled()) {
                        LOG.warn((Object)"Error while saving appointment", (Throwable)e);
                    }
                    appointment.update(ConflictResolutionMode.AlwaysOverwrite, SendInvitationsOrCancellationsMode.SendToNone);
                }
                throw e;
            }
            this.correspondenceService.setCorrespondingId(username, event.getId(), appointment.getId().getUniqueId());
            appointmentSavedCallback.apply(appointment);
        }
        return false;
    }

    public void deleteAppointmentByExoEventId(String username, ExchangeService service, String eventId, String calendarId) throws Exception {
        String itemId = this.correspondenceService.getCorrespondingId(username, eventId);
        if (itemId == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"The event was deleted from eXo but seems don't have corresponding Event in Exchange, ignore.");
            }
        } else if (this.correspondenceService.getCorrespondingId(username, calendarId) == null) {
            LOG.warn((Object)("Calendar with id '" + calendarId + "' seems not synchronized with exchange."));
            this.correspondenceService.deleteCorrespondingId(username, eventId);
        } else {
            this.deleteAppointment(username, service, itemId);
        }
    }

    public void deleteAppointment(String username, ExchangeService service, String itemId) throws Exception {
        this.deleteAppointment(username, service, ItemId.getItemIdFromString((String)itemId));
    }

    public void deleteAppointment(String username, ExchangeService service, ItemId itemId) throws Exception {
        block3: {
            Appointment appointment = null;
            try {
                appointment = Appointment.bind((ExchangeService)service, (ItemId)itemId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("DELETE Exchange appointment: " + appointment.getSubject()));
                }
                appointment.delete(DeleteMode.HardDelete);
            }
            catch (ServiceResponseException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)("Exchange Item was not bound, it was deleted or not yet created:" + itemId));
            }
        }
        this.correspondenceService.deleteCorrespondingId(username, itemId.getUniqueId());
    }

    public void deleteExchangeFolderByCalenarId(String username, ExchangeService service, String calendarId) throws Exception {
        block4: {
            if (CalendarConverterUtils.isExchangeCalendarId(calendarId)) {
                LOG.warn((Object)("Can't delete Exchange Calendar, because it was created on Exchange: " + calendarId));
                return;
            }
            String folderId = this.correspondenceService.getCorrespondingId(username, calendarId);
            if (folderId == null) {
                LOG.warn((Object)"Conflict in modification, inconsistant data, the Calendar was deleted from eXo but seems don't have corresponding Folder in Exchange, ignore.");
                return;
            }
            Folder folder = null;
            try {
                folder = Folder.bind((ExchangeService)service, (FolderId)FolderId.getFolderIdFromString((String)folderId));
                LOG.trace((Object)("DELETE Exchange folder: " + folder.getDisplayName()));
                folder.delete(DeleteMode.MoveToDeletedItems);
            }
            catch (ServiceResponseException e) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace((Object)("Exchange Folder was not bound, it was deleted or not yet created:" + folderId));
            }
        }
        this.correspondenceService.deleteCorrespondingId(username, calendarId);
    }

    public CalendarFolder getExchangeCalendar(ExchangeService service, String folderId) throws Exception {
        return this.getExchangeCalendar(service, FolderId.getFolderIdFromString((String)folderId));
    }

    public CalendarFolder getExchangeCalendar(ExchangeService service, FolderId folderId) throws Exception {
        CalendarFolder folder = null;
        try {
            folder = CalendarFolder.bind((ExchangeService)service, (FolderId)folderId);
        }
        catch (ServiceResponseException e) {
            LOG.warn((Object)("Can't get Folder identified by id: " + folderId.getUniqueId()));
        }
        return folder;
    }

    public Item getItem(ExchangeService service, String itemId) throws Exception {
        return this.getItem(service, ItemId.getItemIdFromString((String)itemId));
    }

    public Item getItem(ExchangeService service, ItemId itemId) throws Exception {
        Item item = null;
        try {
            item = Item.bind((ExchangeService)service, (ItemId)itemId);
        }
        catch (ServiceResponseException e) {
            LOG.debug((Object)("Can't get item identified by id: " + itemId.getUniqueId()));
        }
        return item;
    }

    private List<Folder> searchSubFolders(ExchangeService service, FolderId parentFolderId) throws Exception {
        FolderView view = new FolderView(1000);
        view.setPropertySet(new PropertySet(BasePropertySet.FirstClassProperties));
        FindFoldersResults findResults = service.findFolders(parentFolderId, view);
        return findResults.getFolders();
    }

    private Appointment getAppointmentOccurence(ExchangeService service, String exchangeMasterId, String recurrenceId) throws Exception {
        Appointment masterAppointment = Appointment.bind((ExchangeService)service, (ItemId)ItemId.getItemIdFromString((String)exchangeMasterId), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.Recurrence}));
        return CalendarConverterUtils.getAppointmentOccurence(masterAppointment, recurrenceId);
    }

    private Date getLastModifiedDate(Appointment appointment) throws Exception {
        try {
            return appointment.getLastModifiedTime();
        }
        catch (ServiceObjectPropertyException e) {
            Appointment appointmentWithModifiedDate = Appointment.bind((ExchangeService)appointment.getService(), (ItemId)appointment.getId(), (PropertySet)new PropertySet(new PropertyDefinitionBase[]{AppointmentSchema.LastModifiedTime}));
            return appointmentWithModifiedDate.getLastModifiedTime();
        }
    }
}

