/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover.configuration.outlook;

import java.util.HashMap;
import java.util.List;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.autodiscover.AlternateMailbox;
import microsoft.exchange.webservices.data.autodiscover.AlternateMailboxCollection;
import microsoft.exchange.webservices.data.autodiscover.configuration.outlook.OutlookProtocol;
import microsoft.exchange.webservices.data.autodiscover.enumeration.AutodiscoverResponseType;
import microsoft.exchange.webservices.data.autodiscover.enumeration.OutlookProtocolType;
import microsoft.exchange.webservices.data.autodiscover.enumeration.UserSettingName;
import microsoft.exchange.webservices.data.autodiscover.response.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
final class OutlookAccount {
    private static final String Settings = "settings";
    private static final String RedirectAddr = "redirectAddr";
    private static final String RedirectUrl = "redirectUrl";
    private String accountType;
    private AutodiscoverResponseType responseType;
    private HashMap<OutlookProtocolType, OutlookProtocol> protocols = new HashMap();
    private AlternateMailboxCollection alternateMailboxes = new AlternateMailboxCollection();
    private String redirectTarget;

    protected OutlookAccount() {
    }

    protected void loadFromXml(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("AccountType")) {
                this.setAccountType(reader.readElementValue());
                continue;
            }
            if (reader.getLocalName().equals("Action")) {
                String xmlResponseType = reader.readElementValue();
                if (xmlResponseType.equals(Settings)) {
                    this.setResponseType(AutodiscoverResponseType.Success);
                    continue;
                }
                if (xmlResponseType.equals(RedirectUrl)) {
                    this.setResponseType(AutodiscoverResponseType.RedirectUrl);
                    continue;
                }
                if (xmlResponseType.equals(RedirectAddr)) {
                    this.setResponseType(AutodiscoverResponseType.RedirectAddress);
                    continue;
                }
                this.setResponseType(AutodiscoverResponseType.Error);
                continue;
            }
            if (reader.getLocalName().equals("Protocol")) {
                OutlookProtocol protocol = new OutlookProtocol();
                protocol.loadFromXml(reader);
                this.protocols.put(protocol.getProtocolType(), protocol);
                continue;
            }
            if (reader.getLocalName().equals("RedirectAddr")) {
                this.setRedirectTarget(reader.readElementValue());
                continue;
            }
            if (reader.getLocalName().equals("RedirectUrl")) {
                this.setRedirectTarget(reader.readElementValue());
                continue;
            }
            if (reader.getLocalName().equals("AlternateMailboxes")) {
                AlternateMailbox alternateMailbox = AlternateMailbox.loadFromXml(reader);
                this.alternateMailboxes.getEntries().add(alternateMailbox);
                continue;
            }
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, "Account"));
    }

    protected void convertToUserSettings(List<UserSettingName> requestedSettings, GetUserSettingsResponse response) {
        for (OutlookProtocol protocol : this.protocols.values()) {
            protocol.convertToUserSettings(requestedSettings, response);
        }
        if (requestedSettings.contains((Object)UserSettingName.AlternateMailboxes)) {
            response.getSettings().put(UserSettingName.AlternateMailboxes, this.alternateMailboxes);
        }
    }

    protected String getAccountType() {
        return this.accountType;
    }

    protected void setAccountType(String value) {
        this.accountType = value;
    }

    protected AutodiscoverResponseType getResponseType() {
        return this.responseType;
    }

    protected void setResponseType(AutodiscoverResponseType value) {
        this.responseType = value;
    }

    protected String getRedirectTarget() {
        return this.redirectTarget;
    }

    protected void setRedirectTarget(String value) {
        this.redirectTarget = value;
    }
}

