/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.IdFormat;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ConvertIdResponse;
import microsoft.exchange.webservices.data.misc.id.AlternateIdBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConvertIdRequest
extends MultiResponseServiceRequest<ConvertIdResponse> {
    private IdFormat destinationFormat = IdFormat.EwsId;
    private List<AlternateIdBase> ids = new ArrayList<AlternateIdBase>();

    public ConvertIdRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected ConvertIdResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ConvertIdResponse();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ConvertIdResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ConvertIdResponseMessage";
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.ids.size();
    }

    @Override
    public String getXmlElementName() {
        return "ConvertId";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.ids.iterator(), "Ids");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeAttributeValue("DestinationFormat", (Object)this.destinationFormat);
        writer.writeStartElement(XmlNamespace.Messages, "SourceIds");
        for (AlternateIdBase alternateId : this.ids) {
            alternateId.writeToXml(writer);
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public IdFormat getDestinationFormat() {
        return this.destinationFormat;
    }

    public void setDestinationFormat(IdFormat destinationFormat) {
        this.destinationFormat = destinationFormat;
    }

    public List<AlternateIdBase> getIds() {
        return this.ids;
    }
}

