/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.FolderIdWrapperList;
import microsoft.exchange.webservices.data.search.Grouping;
import microsoft.exchange.webservices.data.search.ViewBase;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FindRequest<TResponse extends ServiceResponse>
extends MultiResponseServiceRequest<TResponse> {
    private static final Log LOG = LogFactory.getLog(FindRequest.class);
    private FolderIdWrapperList parentFolderIds = new FolderIdWrapperList();
    private SearchFilter searchFilter;
    private String queryString;
    private ViewBase view;

    protected FindRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        this.getView().internalValidate(this);
        if (this.queryString != null && !this.queryString.isEmpty() && this.getService().getRequestedServerVersion().ordinal() < ExchangeVersion.Exchange2010.ordinal()) {
            throw new ServiceVersionException(String.format("The parameter %s is only valid for Exchange Server version %s or a later version.", new Object[]{"queryString", ExchangeVersion.Exchange2010}));
        }
        if (this.queryString != null && !this.queryString.isEmpty() && this.searchFilter != null) {
            throw new ServiceLocalException("Both search filter and query string can't be specified. One of them must be null.");
        }
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getParentFolderIds().getCount();
    }

    protected Grouping getGroupBy() {
        return null;
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        this.getView().writeAttributesToXml(writer);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getView().writeToXml(writer, this.getGroupBy());
        if (this.getSearchFilter() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "Restriction");
            this.getSearchFilter().writeToXml(writer);
            writer.writeEndElement();
        }
        this.getView().writeOrderByToXml(writer);
        try {
            this.getParentFolderIds().writeToXml(writer, XmlNamespace.Messages, "ParentFolderIds");
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        if (this.queryString != null && !this.queryString.isEmpty()) {
            writer.writeElementValue(XmlNamespace.Messages, "QueryString", this.queryString);
        }
    }

    public FolderIdWrapperList getParentFolderIds() {
        return this.parentFolderIds;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(SearchFilter searchFilter) {
        this.searchFilter = searchFilter;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public ViewBase getView() {
        return this.view;
    }

    public void setView(ViewBase view) {
        this.view = view;
    }
}

