/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.item;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import microsoft.exchange.webservices.data.attribute.ServiceObjectDefinition;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.Importance;
import microsoft.exchange.webservices.data.core.enumeration.service.ConversationFlagStatus;
import microsoft.exchange.webservices.data.core.enumeration.service.DeleteMode;
import microsoft.exchange.webservices.data.core.enumeration.service.SendCancellationsMode;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AffectedTaskOccurrence;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.schema.ConversationSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ConversationId;
import microsoft.exchange.webservices.data.property.complex.ExtendedPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemIdCollection;
import microsoft.exchange.webservices.data.property.complex.StringList;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceObjectDefinition(xmlElementName="Conversation")
public class Conversation
extends ServiceObject {
    public Conversation(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return ConversationSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    @Override
    public PropertyDefinition getIdPropertyDefinition() {
        return ConversationSchema.Id;
    }

    @Override
    protected void internalLoad(PropertySet propertySet) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void internalDelete(DeleteMode deleteMode, SendCancellationsMode sendCancellationsMode, AffectedTaskOccurrence affectedTaskOccurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getChangeXmlElementName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDeleteFieldXmlElementName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSetFieldXmlElementName() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean getIsTimeZoneHeaderRequired(boolean isUpdateOperation) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ExtendedPropertyCollection getExtendedProperties() {
        throw new UnsupportedOperationException();
    }

    public void enableAlwaysCategorizeItems(Iterable<String> categories, boolean processSynchronously) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        ArrayList<ConversationId> convArry = new ArrayList<ConversationId>();
        convArry.add(this.getId());
        this.getService().enableAlwaysCategorizeItemsInConversations(convArry, categories, processSynchronously).getResponseAtIndex(0).throwIfNecessary();
    }

    public void disableAlwaysCategorizeItems(boolean processSynchronously) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        ArrayList<ConversationId> convArry = new ArrayList<ConversationId>();
        convArry.add(this.getId());
        this.getService().disableAlwaysCategorizeItemsInConversations(convArry, processSynchronously).getResponseAtIndex(0).throwIfNecessary();
    }

    public void enableAlwaysDeleteItems(boolean processSynchronously) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        ArrayList<ConversationId> convArry = new ArrayList<ConversationId>();
        convArry.add(this.getId());
        this.getService().enableAlwaysDeleteItemsInConversations(convArry, processSynchronously).getResponseAtIndex(0).throwIfNecessary();
    }

    public void disableAlwaysDeleteItems(boolean processSynchronously) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        ArrayList<ConversationId> convArry = new ArrayList<ConversationId>();
        convArry.add(this.getId());
        this.getService().disableAlwaysDeleteItemsInConversations(convArry, processSynchronously).getResponseAtIndex(0).throwIfNecessary();
    }

    public void enableAlwaysMoveItems(FolderId destinationFolderId, boolean processSynchronously) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        ArrayList<ConversationId> convArry = new ArrayList<ConversationId>();
        convArry.add(this.getId());
        this.getService().enableAlwaysMoveItemsInConversations(convArry, destinationFolderId, processSynchronously).getResponseAtIndex(0).throwIfNecessary();
    }

    public void disableAlwaysMoveItemsInConversation(boolean processSynchronously) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        ArrayList<ConversationId> convArry = new ArrayList<ConversationId>();
        convArry.add(this.getId());
        this.getService().disableAlwaysMoveItemsInConversations(convArry, processSynchronously).getResponseAtIndex(0).throwIfNecessary();
    }

    public void deleteItems(FolderId contextFolderId, DeleteMode deleteMode) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        HashMap<ConversationId, Date> m = new HashMap<ConversationId, Date>();
        m.put(this.getId(), this.getGlobalLastDeliveryTime());
        ArrayList<HashMap<ConversationId, Date>> f = new ArrayList<HashMap<ConversationId, Date>>();
        f.add(m);
        this.getService().deleteItemsInConversations(f, contextFolderId, deleteMode).getResponseAtIndex(0).throwIfNecessary();
    }

    public void moveItemsInConversation(FolderId contextFolderId, FolderId destinationFolderId) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        HashMap<ConversationId, Date> m = new HashMap<ConversationId, Date>();
        m.put(this.getId(), this.getGlobalLastDeliveryTime());
        ArrayList<HashMap<ConversationId, Date>> f = new ArrayList<HashMap<ConversationId, Date>>();
        f.add(m);
        this.getService().moveItemsInConversations(f, contextFolderId, destinationFolderId).getResponseAtIndex(0).throwIfNecessary();
    }

    public void copyItemsInConversation(FolderId contextFolderId, FolderId destinationFolderId) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        HashMap<ConversationId, Date> m = new HashMap<ConversationId, Date>();
        m.put(this.getId(), this.getGlobalLastDeliveryTime());
        ArrayList<HashMap<ConversationId, Date>> f = new ArrayList<HashMap<ConversationId, Date>>();
        f.add(m);
        this.getService().copyItemsInConversations(f, contextFolderId, destinationFolderId).getResponseAtIndex(0).throwIfNecessary();
    }

    public void setReadStateForItemsInConversation(FolderId contextFolderId, boolean isRead) throws ServiceResponseException, IndexOutOfBoundsException, Exception {
        HashMap<ConversationId, Date> m = new HashMap<ConversationId, Date>();
        m.put(this.getId(), this.getGlobalLastDeliveryTime());
        ArrayList<HashMap<ConversationId, Date>> f = new ArrayList<HashMap<ConversationId, Date>>();
        f.add(m);
        this.getService().setReadStateForItemsInConversations(f, contextFolderId, isRead).getResponseAtIndex(0).throwIfNecessary();
    }

    @Override
    public ConversationId getId() throws ServiceLocalException {
        return (ConversationId)this.getPropertyBag().getObjectFromPropertyDefinition(this.getIdPropertyDefinition());
    }

    public String getTopic() throws ArgumentException {
        String returnValue = "";
        if (this.getPropertyBag().contains(ConversationSchema.Topic)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(String.class, ConversationSchema.Topic, out);
            returnValue = (String)out.getParam();
        }
        return returnValue;
    }

    public StringList getUniqueRecipients() throws Exception {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.UniqueRecipients);
    }

    public StringList getGlobalUniqueRecipients() throws Exception {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalUniqueRecipients);
    }

    public StringList getUniqueUnreadSenders() throws ArgumentException {
        StringList unreadSenders = null;
        if (this.getPropertyBag().contains(ConversationSchema.UniqueUnreadSenders)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(StringList.class, ConversationSchema.UniqueUnreadSenders, out);
            unreadSenders = (StringList)out.getParam();
        }
        return unreadSenders;
    }

    public StringList getGlobalUniqueUnreadSenders() throws ArgumentException {
        StringList unreadSenders = null;
        if (this.getPropertyBag().contains(ConversationSchema.GlobalUniqueUnreadSenders)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(StringList.class, ConversationSchema.GlobalUniqueUnreadSenders, out);
            unreadSenders = (StringList)out.getParam();
        }
        return unreadSenders;
    }

    public StringList getUniqueSenders() throws Exception {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.UniqueSenders);
    }

    public StringList getGlobalUniqueSenders() throws Exception {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalUniqueSenders);
    }

    public Date getLastDeliveryTime() throws Exception {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.LastDeliveryTime);
    }

    public Date getGlobalLastDeliveryTime() throws Exception {
        return (Date)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalLastDeliveryTime);
    }

    public StringList getCategories() throws ArgumentException {
        StringList returnValue = null;
        if (this.getPropertyBag().contains(ConversationSchema.Categories)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(StringList.class, ConversationSchema.Categories, out);
            returnValue = (StringList)out.getParam();
        }
        return returnValue;
    }

    public StringList getGlobalCategories() throws ArgumentException {
        StringList returnValue = null;
        if (this.getPropertyBag().contains(ConversationSchema.GlobalCategories)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(StringList.class, ConversationSchema.GlobalCategories, out);
            returnValue = (StringList)out.getParam();
        }
        return returnValue;
    }

    public ConversationFlagStatus getFlagStatus() throws ArgumentException {
        ConversationFlagStatus returnValue = ConversationFlagStatus.NotFlagged;
        if (this.getPropertyBag().contains(ConversationSchema.FlagStatus)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(ConversationFlagStatus.class, ConversationSchema.FlagStatus, out);
            returnValue = (ConversationFlagStatus)((Object)out.getParam());
        }
        return returnValue;
    }

    public ConversationFlagStatus getGlobalFlagStatus() throws ArgumentException {
        ConversationFlagStatus returnValue = ConversationFlagStatus.NotFlagged;
        if (this.getPropertyBag().contains(ConversationSchema.GlobalFlagStatus)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(ConversationFlagStatus.class, ConversationSchema.GlobalFlagStatus, out);
            returnValue = (ConversationFlagStatus)((Object)out.getParam());
        }
        return returnValue;
    }

    public boolean getHasAttachments() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.HasAttachments);
    }

    public boolean getGlobalHasAttachments() throws ServiceLocalException {
        return (Boolean)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalHasAttachments);
    }

    public int getMessageCount() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.MessageCount);
    }

    public int getGlobalMessageCount() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalMessageCount);
    }

    public int getUnreadCount() throws ArgumentException {
        int returnValue = 0;
        if (this.getPropertyBag().contains(ConversationSchema.UnreadCount)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(Integer.class, ConversationSchema.UnreadCount, out);
            returnValue = (Integer)out.getParam();
        }
        return returnValue;
    }

    public int getGlobalUnreadCount() throws ArgumentException {
        int returnValue = 0;
        if (this.getPropertyBag().contains(ConversationSchema.GlobalUnreadCount)) {
            OutParam out = new OutParam();
            this.getPropertyBag().tryGetPropertyType(Integer.class, ConversationSchema.GlobalUnreadCount, out);
            returnValue = (Integer)out.getParam();
        }
        return returnValue;
    }

    public int getSize() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.Size);
    }

    public int getGlobalSize() throws ServiceLocalException {
        return (Integer)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalSize);
    }

    public StringList getItemClasses() throws Exception {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.ItemClasses);
    }

    public StringList getGlobalItemClasses() throws Exception {
        return (StringList)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalItemClasses);
    }

    public Importance getImportance() throws Exception {
        return (Importance)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.Importance));
    }

    public Importance getGlobalImportance() throws Exception {
        return (Importance)((Object)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalImportance));
    }

    public ItemIdCollection getItemIds() throws Exception {
        return (ItemIdCollection)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.ItemIds);
    }

    public ItemIdCollection getGlobalItemIds() throws Exception {
        return (ItemIdCollection)this.getPropertyBag().getObjectFromPropertyDefinition(ConversationSchema.GlobalItemIds);
    }
}

