/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.request.HangingServiceRequestBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HangingTraceStream
extends InputStream {
    private static final Log LOG = LogFactory.getLog(HangingTraceStream.class);
    private final InputStream underlyingStream;
    private final ExchangeService service;
    private ByteArrayOutputStream responseCopy;

    public HangingTraceStream(InputStream stream, ExchangeService service) {
        this.underlyingStream = stream;
        this.service = service;
    }

    public boolean getCanRead() {
        return true;
    }

    public boolean getCanSeek() {
        return false;
    }

    public boolean getCanWrite() {
        return false;
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        count = 4096;
        int retVal = this.underlyingStream.read(buffer, offset, count);
        if (HangingServiceRequestBase.isLogAllWireBytes()) {
            String readString = new String(buffer, offset, count, "UTF-8");
            String logMessage = String.format("HangingTraceStream ID [%d] returned %d bytes. Bytes returned: [%s]", this.hashCode(), retVal, readString);
            try {
                this.service.traceMessage(TraceFlags.DebugMessage, logMessage);
            }
            catch (XMLStreamException e) {
                LOG.error((Object)e);
            }
        }
        if (this.responseCopy != null) {
            this.responseCopy.write(buffer, offset, retVal);
        }
        return retVal;
    }

    public void setResponseCopy(ByteArrayOutputStream responseCopy) {
        this.responseCopy = responseCopy;
    }

    public int read() throws IOException {
        return 0;
    }
}

