/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ILazyMember;
import microsoft.exchange.webservices.data.core.LazyMember;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentNullException;
import microsoft.exchange.webservices.data.core.exception.misc.FormatException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.misc.IFunction;
import microsoft.exchange.webservices.data.misc.IFunctions;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapiTypeConverterMapEntry {
    private static final Log LOG = LogFactory.getLog(MapiTypeConverterMapEntry.class);
    private static LazyMember<Map<Class<?>, Object>> defaultValueMap = new LazyMember(new ILazyMember<Map<Class<?>, Object>>(){

        @Override
        public Map<Class<?>, Object> createInstance() {
            HashMap map = new HashMap();
            map.put(Boolean.class, false);
            map.put(Byte[].class, null);
            map.put(Short.class, new Short(0));
            map.put(Integer.class, 0);
            map.put(Long.class, new Long(0L));
            map.put(Float.class, new Float(0.0));
            map.put(Double.class, new Double(0.0));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                map.put(Date.class, formatter.parse("0001-01-01 12:00:00"));
            }
            catch (ParseException e) {
                LOG.error((Object)e);
            }
            map.put(UUID.class, UUID.fromString("00000000-0000-0000-0000-000000000000"));
            map.put(String.class, null);
            return map;
        }
    });
    boolean isArray;
    Class<?> type;
    IFunction<Object, String> convertToString;
    IFunction<String, Object> parse;

    public MapiTypeConverterMapEntry(Class<?> type) {
        EwsUtilities.ewsAssert(defaultValueMap.getMember().containsKey(type), "MapiTypeConverterMapEntry ctor", "No default value entry for type " + type.getName());
        this.type = type;
        this.convertToString = IFunctions.ToString.INSTANCE;
        this.parse = IFunctions.StringToObject.INSTANCE;
    }

    public Object changeType(Object value) throws Exception {
        if (this.getIsArray()) {
            this.validateValueAsArray(value);
            return value;
        }
        if (value.getClass() == this.getType()) {
            return value;
        }
        try {
            if (this.getType().isInstance(0)) {
                Integer o = null;
                o = Integer.parseInt(value + "");
                return o;
            }
            if (this.getType().isInstance(new Date())) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return df.parse(value + "");
            }
            if (this.getType().isInstance(false)) {
                Boolean o = null;
                o = Boolean.parseBoolean(value + "");
                return o;
            }
            if (this.getType().isInstance(String.class)) {
                return value;
            }
            return null;
        }
        catch (ClassCastException ex) {
            throw new ArgumentException(String.format("The value '%s' of type %s can't be converted to a value of type %s.", "%s", "%s", this.getType()), ex);
        }
    }

    public Object convertToValue(String stringValue) throws ServiceXmlDeserializationException, FormatException {
        try {
            return this.getParse().func(stringValue);
        }
        catch (ClassCastException ex) {
            throw new ServiceXmlDeserializationException(String.format("The value '%s' couldn't be converted to type %s.", stringValue, this.getType()), ex);
        }
        catch (NumberFormatException ex) {
            throw new ServiceXmlDeserializationException(String.format("The value '%s' couldn't be converted to type %s.", stringValue, this.getType()), ex);
        }
    }

    public Object convertToValueOrDefault(String stringValue) throws ServiceXmlDeserializationException, FormatException {
        return StringUtils.isEmpty((CharSequence)stringValue) ? this.getDefaultValue() : this.convertToValue(stringValue);
    }

    private void validateValueAsArray(Object value) throws ArgumentException, ArgumentNullException {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)value;
            if (arrayList.isEmpty()) {
                throw new ArgumentException("The Array value must have at least one element.");
            }
            if (arrayList.get(0).getClass() != this.getType()) {
                throw new ArgumentException(String.format("Type %s can't be used as an array of type %s.", value.getClass(), this.getType()));
            }
        }
    }

    public static int getDim(Object array) {
        int dim = 0;
        Class<?> cls = array.getClass();
        while (cls.isArray()) {
            ++dim;
            cls = cls.getComponentType();
        }
        return dim;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> cls) {
        this.type = cls;
    }

    public boolean getIsArray() {
        return this.isArray;
    }

    protected void setIsArray(boolean value) {
        this.isArray = value;
    }

    protected IFunction<Object, String> getConvertToString() {
        return this.convertToString;
    }

    protected void setConvertToString(IFunction<Object, String> value) {
        this.convertToString = value;
    }

    protected IFunction<String, Object> getParse() {
        return this.parse;
    }

    protected void setParse(IFunction<String, Object> value) {
        this.parse = value;
    }

    protected Object getDefaultValue() {
        return defaultValueMap.getMember().get(this.type);
    }
}

