/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc;

import java.io.Serializable;
import java.util.Date;
import microsoft.exchange.webservices.data.core.exception.misc.FormatException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSpan
implements Comparable<TimeSpan>,
Serializable,
Cloneable {
    private static final Log LOG = LogFactory.getLog(TimeSpan.class);
    private static final long serialVersionUID = 1L;
    private long time = 0L;
    public static final int MILLISECONDS = 1;
    public static final int SECONDS = 1000;
    public static final int MINUTES = 60000;
    public static final int HOURS = 3600000;
    public static final int DAYS = 86400000;
    public static final TimeSpan MAX_VALUE = new TimeSpan(Long.MAX_VALUE);
    public static final TimeSpan MIN_VALUE = new TimeSpan(Long.MIN_VALUE);
    public static final TimeSpan ZERO = new TimeSpan(0L);

    public TimeSpan(long time) {
        this.time = time;
    }

    public TimeSpan(int units, long value) {
        this.time = TimeSpan.toMilliseconds(units, value);
    }

    public static TimeSpan subtract(Date date1, Date date2) {
        return new TimeSpan(date1.getTime() - date2.getTime());
    }

    @Override
    public int compareTo(TimeSpan o) {
        TimeSpan compare = o;
        if (this.time == compare.time) {
            return 0;
        }
        if (this.time > compare.time) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimeSpan) {
            TimeSpan compare = (TimeSpan)obj;
            if (this.time == compare.time) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.time).hashCode();
    }

    public String toString() {
        long day;
        StringBuffer sb = new StringBuffer();
        long millis = this.time;
        if (millis < 0L) {
            sb.append("-");
            millis = -millis;
        }
        if ((day = millis / 86400000L) != 0L) {
            sb.append(day);
            sb.append("d.");
            millis %= 86400000L;
        }
        sb.append(millis / 3600000L);
        sb.append("h:");
        sb.append((millis %= 3600000L) / 60000L);
        sb.append("m:");
        sb.append((millis %= 60000L) / 1000L);
        sb.append("s");
        if ((millis %= 1000L) != 0L) {
            sb.append(".");
            sb.append(millis);
            sb.append("ms");
        }
        return sb.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Object)e);
            throw new InternalError();
        }
    }

    public boolean isPositive() {
        return this.compareTo(ZERO) > 0;
    }

    public boolean isNegative() {
        return this.compareTo(ZERO) < 0;
    }

    public boolean isZero() {
        return this.equals(ZERO);
    }

    public long getMilliseconds() {
        return this.time % 3600000L % 60000L % 1L / 1L;
    }

    public long getTotalMilliseconds() {
        return this.time;
    }

    public long getSeconds() {
        return this.time % 3600000L % 60000L / 1000L;
    }

    public double getTotalSeconds() {
        return (double)this.time / 1000.0;
    }

    public long getMinutes() {
        return this.time % 3600000L / 60000L;
    }

    public double getTotalMinutes() {
        return (double)this.time / 1000.0 / 60.0;
    }

    public long getHours() {
        return this.time / 1000L / 60L / 60L;
    }

    public double getTotalHours() {
        return (double)this.time / 1000.0 / 60.0 / 60.0;
    }

    public long getDays() {
        return this.time / 1000L / 60L / 60L / 24L;
    }

    public double getTotalDays() {
        return (double)this.time / 1000.0 / 60.0 / 60.0 / 24.0;
    }

    public void add(TimeSpan timespan) {
        this.add(1, timespan.time);
    }

    public void add(int units, long value) {
        this.time += TimeSpan.toMilliseconds(units, value);
    }

    public static int compare(TimeSpan first, TimeSpan second) {
        if (first.time == second.time) {
            return 0;
        }
        if (first.time > second.time) {
            return 1;
        }
        return -1;
    }

    public TimeSpan duration() {
        return new TimeSpan(Math.abs(this.time));
    }

    public TimeSpan negate() {
        return new TimeSpan(-this.time);
    }

    public void subtract(TimeSpan timespan) {
        this.subtract(1, timespan.time);
    }

    public void subtract(int units, long value) {
        this.add(units, -value);
    }

    private static long toMilliseconds(int units, long value) {
        long millis;
        switch (units) {
            case 1: 
            case 1000: 
            case 60000: 
            case 3600000: 
            case 86400000: {
                millis = value * (long)units;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized units: " + units);
            }
        }
        return millis;
    }

    public static TimeSpan parse(String s) throws Exception {
        String str = s.trim();
        String[] st1 = str.split("\\.");
        int days = 0;
        int millsec = 0;
        int totMillSec = 0;
        String data = str;
        switch (st1.length) {
            case 1: {
                data = str;
                break;
            }
            case 2: {
                if (st1[0].split(":").length > 1) {
                    millsec = Integer.parseInt(st1[1]);
                    data = st1[0];
                    break;
                }
                days = Integer.parseInt(st1[0]);
                data = st1[1];
                break;
            }
            case 3: {
                days = Integer.parseInt(st1[0]);
                data = st1[1];
                millsec = Integer.parseInt(st1[2]);
                break;
            }
            default: {
                throw new FormatException("Bad Format");
            }
        }
        String[] st = data.split(":");
        switch (st.length) {
            case 1: {
                totMillSec = Integer.parseInt(str) * 24 * 60 * 60 * 1000;
                break;
            }
            case 2: {
                totMillSec = Integer.parseInt(st[0]) * 60 * 60 * 1000 + Integer.parseInt(st[1]) * 60 * 1000;
                break;
            }
            case 3: {
                totMillSec = Integer.parseInt(st[0]) * 60 * 60 * 1000 + Integer.parseInt(st[1]) * 60 * 1000 + Integer.parseInt(st[2]) * 1000;
                break;
            }
            case 4: {
                totMillSec = Integer.parseInt(st[0]) * 24 * 60 * 60 * 1000 + Integer.parseInt(st[1]) * 60 * 60 * 1000 + Integer.parseInt(st[2]) * 60 * 1000 + Integer.parseInt(st[3]) * 1000;
                break;
            }
            default: {
                throw new FormatException("Bad Format/Overflow");
            }
        }
        return new TimeSpan(totMillSec += days * 24 * 60 * 60 * 1000 + millsec);
    }
}

