/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc.id;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.IdFormat;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.id.AlternateIdBase;

public class AlternateId
extends AlternateIdBase {
    public static final String SchemaTypeName = "AlternateIdType";
    private String id;
    private String mailbox;
    private boolean isArchive;

    public AlternateId() {
    }

    public AlternateId(IdFormat format, String id, String mailbox) {
        super(format);
        this.setUniqueId(id);
        this.setMailbox(mailbox);
    }

    public AlternateId(IdFormat format, String id, String mailbox, boolean isArchive) {
        super(format);
        this.setUniqueId(id);
        this.setMailbox(mailbox);
        this.setIsArchive(isArchive);
    }

    public String getUniqueId() {
        return this.id;
    }

    public void setUniqueId(String id) {
        this.id = id;
    }

    public String getMailbox() {
        return this.mailbox;
    }

    public void setMailbox(String mailbox) {
        this.mailbox = mailbox;
    }

    public boolean getIsArchive() {
        return this.isArchive;
    }

    public void setIsArchive(boolean isArchive) {
        this.isArchive = isArchive;
    }

    protected String getXmlElementName() {
        return "AlternateId";
    }

    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("Id", this.getUniqueId());
        writer.writeAttributeValue("Mailbox", this.getMailbox());
        if (this.getIsArchive()) {
            writer.writeAttributeValue("IsArchive", true);
        }
    }

    public void loadAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        super.loadAttributesFromXml(reader);
        this.setUniqueId(reader.readAttributeValue("Id"));
        this.setMailbox(reader.readAttributeValue("Mailbox"));
        String isArchive = reader.readAttributeValue("IsArchive");
        this.isArchive = isArchive != null && !isArchive.isEmpty() ? reader.readAttributeValue(Boolean.class, "IsArchive") : false;
    }

    protected void internalValidate() throws Exception {
        EwsUtilities.validateParam(this.getMailbox(), "mailbox");
    }
}

