/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.property.complex.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.FolderPermission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FolderPermissionCollection
extends ComplexPropertyCollection<FolderPermission> {
    private static final Log LOG = LogFactory.getLog(FolderPermissionCollection.class);
    private boolean isCalendarFolder;
    private Collection<String> unknownEntries = new ArrayList<String>();

    public FolderPermissionCollection(Folder owner) {
        this.isCalendarFolder = owner instanceof CalendarFolder;
    }

    private String getInnerCollectionXmlElementName() {
        return this.isCalendarFolder ? "CalendarPermissions" : "Permissions";
    }

    private String getCollectionItemXmlElementName() {
        return this.isCalendarFolder ? "CalendarPermission" : "Permission";
    }

    @Override
    protected String getCollectionItemXmlElementName(FolderPermission complexProperty) {
        return this.getCollectionItemXmlElementName();
    }

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, localElementName);
        reader.readStartElement(XmlNamespace.Types, this.getInnerCollectionXmlElementName());
        super.loadFromXml(reader, this.getInnerCollectionXmlElementName());
        reader.readEndElementIfNecessary(XmlNamespace.Types, this.getInnerCollectionXmlElementName());
        reader.read();
        if (reader.isStartElement(XmlNamespace.Types, "UnknownEntries")) {
            do {
                reader.read();
                if (!reader.isStartElement(XmlNamespace.Types, "UnknownEntry")) continue;
                this.unknownEntries.add(reader.readElementValue());
            } while (!reader.isEndElement(XmlNamespace.Types, "UnknownEntries"));
        }
    }

    @Override
    public void validate() {
        for (int permissionIndex = 0; permissionIndex < this.getItems().size(); ++permissionIndex) {
            FolderPermission permission = (FolderPermission)this.getItems().get(permissionIndex);
            try {
                permission.validate(this.isCalendarFolder, permissionIndex);
                continue;
            }
            catch (ServiceValidationException e) {
                LOG.error((Object)e);
                continue;
            }
            catch (ServiceLocalException e) {
                LOG.error((Object)e);
            }
        }
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, this.getInnerCollectionXmlElementName());
        for (FolderPermission folderPermission : this) {
            folderPermission.writeToXml(writer, this.getCollectionItemXmlElementName(folderPermission), this.isCalendarFolder);
        }
        writer.writeEndElement();
    }

    @Override
    protected FolderPermission createComplexProperty(String xmlElementName) {
        return new FolderPermission();
    }

    public void add(FolderPermission permission) {
        this.internalAdd(permission);
    }

    public void addFolderRange(Iterator<FolderPermission> permissions) throws Exception {
        EwsUtilities.validateParam(permissions, "permissions");
        if (null != permissions) {
            while (permissions.hasNext()) {
                this.add(permissions.next());
            }
        }
    }

    public void clear() {
        this.internalClear();
    }

    public boolean remove(FolderPermission permission) {
        return this.internalRemove(permission);
    }

    public void removeAt(int index) {
        this.internalRemoveAt(index);
    }

    public Collection<String> getUnknownEntries() {
        return this.unknownEntries;
    }
}

