/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.time;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.time.AbsoluteDateTransition;
import microsoft.exchange.webservices.data.property.complex.time.AbsoluteDayOfMonthTransition;
import microsoft.exchange.webservices.data.property.complex.time.RelativeDayOfMonthTransition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.complex.time.TimeZonePeriod;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneTransitionGroup;

public class TimeZoneTransition
extends ComplexProperty {
    private final String PeriodTarget = "Period";
    private final String GroupTarget = "Group";
    private TimeZoneDefinition timeZoneDefinition;
    private TimeZonePeriod targetPeriod;
    private TimeZoneTransitionGroup targetGroup;

    public static TimeZoneTransition create(TimeZoneDefinition timeZoneDefinition, String xmlElementName) throws ServiceLocalException {
        if (xmlElementName.equals("AbsoluteDateTransition")) {
            return new AbsoluteDateTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("AbsoluteDateTransition")) {
            return new AbsoluteDateTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("RecurringDayTransition")) {
            return new RelativeDayOfMonthTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("RecurringDateTransition")) {
            return new AbsoluteDayOfMonthTransition(timeZoneDefinition);
        }
        if (xmlElementName.equals("Transition")) {
            return new TimeZoneTransition(timeZoneDefinition);
        }
        throw new ServiceLocalException(String.format("Unknown time zone transition type: %s", xmlElementName));
    }

    protected String getXmlElementName() {
        return "Transition";
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("To")) {
            String targetKind = reader.readAttributeValue("Kind");
            String targetId = reader.readElementValue();
            if (targetKind.equals("Period")) {
                if (!this.timeZoneDefinition.getPeriods().containsKey(targetId)) {
                    throw new ServiceLocalException(String.format("Invalid transition. A period with the specified Id couldn't be found: %s", targetId));
                }
                this.targetPeriod = this.timeZoneDefinition.getPeriods().get(targetId);
            } else if (targetKind.equals("Group")) {
                if (!this.timeZoneDefinition.getTransitionGroups().containsKey(targetId)) {
                    throw new ServiceLocalException(String.format("Invalid transition. A transition group with the specified ID couldn't be found: %s", targetId));
                }
                this.targetGroup = this.timeZoneDefinition.getTransitionGroups().get(targetId);
            } else {
                throw new ServiceLocalException("The time zone transition target isn't supported.");
            }
            return true;
        }
        return false;
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeStartElement(XmlNamespace.Types, "To");
        if (this.targetPeriod != null) {
            writer.writeAttributeValue("Kind", "Period");
            writer.writeValue(this.targetPeriod.getId(), "To");
        } else if (this.targetGroup != null) {
            writer.writeAttributeValue("Kind", "Group");
            writer.writeValue(this.targetGroup.getId(), "To");
        }
        writer.writeEndElement();
    }

    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        this.loadFromXml(reader, this.getXmlElementName());
    }

    public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writeToXml(writer, this.getXmlElementName());
    }

    protected TimeZoneTransition(TimeZoneDefinition timeZoneDefinition) {
        this.timeZoneDefinition = timeZoneDefinition;
    }

    protected TimeZoneTransition(TimeZoneDefinition timeZoneDefinition, TimeZoneTransitionGroup targetGroup) {
        this(timeZoneDefinition);
        this.targetGroup = targetGroup;
    }

    public TimeZoneTransition(TimeZoneDefinition timeZoneDefinition, TimeZonePeriod targetPeriod) {
        this(timeZoneDefinition);
        this.targetPeriod = targetPeriod;
    }

    protected TimeZonePeriod getTargetPeriod() {
        return this.targetPeriod;
    }

    public TimeZoneTransitionGroup getTargetGroup() {
        return this.targetGroup;
    }
}

