/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.autodiscover;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.autodiscover.response.AutodiscoverResponse;
import microsoft.exchange.webservices.data.core.EwsXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AutodiscoverResponseCollection<TResponse extends AutodiscoverResponse>
extends AutodiscoverResponse
implements Iterable<TResponse> {
    private List<TResponse> responses = new ArrayList<TResponse>();

    public int getCount() {
        return this.responses.size();
    }

    public TResponse getTResponseAtIndex(int index) {
        return (TResponse)((AutodiscoverResponse)this.responses.get(index));
    }

    public List<TResponse> getResponses() {
        return this.responses;
    }

    @Override
    public void loadFromXml(EwsXmlReader reader, String endElementName) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals(this.getResponseCollectionXmlElementName())) {
                this.loadResponseCollectionFromXml(reader);
                continue;
            }
            super.loadFromXml(reader, endElementName);
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, endElementName));
    }

    private void loadResponseCollectionFromXml(EwsXmlReader reader) throws Exception {
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1 || !reader.getLocalName().equals(this.getResponseInstanceXmlElementName())) continue;
                TResponse response = this.createResponseInstance();
                ((AutodiscoverResponse)response).loadFromXml(reader, this.getResponseInstanceXmlElementName());
                this.responses.add(response);
            } while (!reader.isEndElement(XmlNamespace.Autodiscover, this.getResponseCollectionXmlElementName()));
        } else {
            reader.read();
        }
    }

    protected abstract String getResponseCollectionXmlElementName();

    protected abstract String getResponseInstanceXmlElementName();

    protected abstract TResponse createResponseInstance();

    @Override
    public Iterator<TResponse> iterator() {
        return this.responses.iterator();
    }
}

