/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.IPropertyBagChangedDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyBag<TKey>
implements Iterable<HashMap<TKey, Object>> {
    private Map<TKey, Object> items = new HashMap<TKey, Object>();
    private List<TKey> removedItems = new ArrayList<TKey>();
    private List<TKey> addedItems = new ArrayList<TKey>();
    private List<TKey> modifiedItems = new ArrayList<TKey>();
    private List<IPropertyBagChangedDelegate<TKey>> onChange = new ArrayList<IPropertyBagChangedDelegate<TKey>>();

    private void internalAddItemToChangeList(TKey key, List<TKey> changeList) {
        if (!changeList.contains(key)) {
            changeList.add(key);
        }
    }

    private void changed() {
        if (!this.onChange.isEmpty()) {
            for (IPropertyBagChangedDelegate<TKey> change : this.onChange) {
                change.propertyBagChanged(this);
            }
        }
    }

    private void internalRemoveItem(TKey key) {
        OutParam<Object> value = new OutParam<Object>();
        if (this.tryGetValue(key, value)) {
            this.items.remove(key);
            this.removedItems.add(key);
            this.changed();
        }
    }

    public Iterable<TKey> getAddedItems() {
        return this.addedItems;
    }

    public Iterable<TKey> getRemovedItems() {
        return this.removedItems;
    }

    public Iterable<TKey> getModifiedItems() {
        return this.modifiedItems;
    }

    public void clearChangeLog() {
        this.removedItems.clear();
        this.addedItems.clear();
        this.modifiedItems.clear();
    }

    public boolean containsKey(TKey key) {
        return this.items.containsKey(key);
    }

    public boolean tryGetValue(TKey key, OutParam<Object> value) {
        if (this.items.containsKey(key)) {
            value.setParam(this.items.get(key));
            return true;
        }
        value.setParam((Object)null);
        return false;
    }

    public Object getSimplePropertyBag(TKey key) {
        OutParam<Object> value = new OutParam<Object>();
        if (this.tryGetValue(key, value)) {
            return value.getParam();
        }
        return null;
    }

    public void setSimplePropertyBag(TKey key, Object value) {
        if (value == null) {
            this.internalRemoveItem(key);
        } else {
            if (this.removedItems.remove(key)) {
                this.internalAddItemToChangeList(key, this.modifiedItems);
            } else if (!this.containsKey(key)) {
                this.internalAddItemToChangeList(key, this.addedItems);
            } else if (!this.modifiedItems.contains(key)) {
                this.internalAddItemToChangeList(key, this.modifiedItems);
            }
            this.items.put(key, value);
            this.changed();
        }
    }

    public void addOnChangeEvent(IPropertyBagChangedDelegate<TKey> change) {
        this.onChange.add(change);
    }

    public void removeChangeEvent(IPropertyBagChangedDelegate<TKey> change) {
        this.onChange.remove(change);
    }

    @Override
    public Iterator<HashMap<TKey, Object>> iterator() {
        return this.items.keySet().iterator();
    }
}

