/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.misc.UserConfiguration;
import microsoft.exchange.webservices.data.property.complex.FolderId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteUserConfigurationRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private String name;
    private FolderId parentFolderId;

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.name, "name");
        EwsUtilities.validateParam(this.parentFolderId, "parentFolderId");
        this.getParentFolderId().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    public String getXmlElementName() {
        return "DeleteUserConfiguration";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "DeleteUserConfigurationResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "DeleteUserConfigurationResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        UserConfiguration.writeUserConfigurationNameToXml(writer, XmlNamespace.Messages, this.name, this.parentFolderId);
    }

    public DeleteUserConfigurationRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    protected String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(FolderId parentFolderId) {
        this.parentFolderId = parentFolderId;
    }
}

