/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.HangingRequestDisconnectReason;
import microsoft.exchange.webservices.data.core.enumeration.misc.TraceFlags;
import microsoft.exchange.webservices.data.core.exception.http.EWSHttpException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceRequestException;
import microsoft.exchange.webservices.data.core.exception.xml.XmlException;
import microsoft.exchange.webservices.data.core.request.HangingRequestDisconnectEventArgs;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.security.XmlNodeType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HangingServiceRequestBase<T>
extends ServiceRequestBase<T> {
    private static final Log LOG = LogFactory.getLog(HangingServiceRequestBase.class);
    public static final int BUFFER_SIZE = 4096;
    private static volatile boolean logAllWireBytes = false;
    private IHandleResponseObject responseHandler;
    private HttpWebRequest response;
    protected int heartbeatFrequencyMilliseconds;
    private List<IHangingRequestDisconnectHandler> onDisconnectList = new ArrayList<IHangingRequestDisconnectHandler>();
    private boolean isConnected;

    public static boolean isLogAllWireBytes() {
        return logAllWireBytes;
    }

    public static void setLogAllWireBytes(boolean logAllWireBytes) {
        HangingServiceRequestBase.logAllWireBytes = logAllWireBytes;
    }

    public void addOnDisconnectEvent(IHangingRequestDisconnectHandler disconnect) {
        this.onDisconnectList.add(disconnect);
    }

    protected void removeDisconnectEvent(IHangingRequestDisconnectHandler disconnect) {
        this.onDisconnectList.remove(disconnect);
    }

    protected void clearDisconnectEvents() {
        this.onDisconnectList.clear();
    }

    protected HangingServiceRequestBase(ExchangeService service, IHandleResponseObject handler, int heartbeatFrequency) throws ServiceVersionException {
        super(service);
        this.responseHandler = handler;
        this.heartbeatFrequencyMilliseconds = heartbeatFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalExecute() throws Exception {
        HangingServiceRequestBase hangingServiceRequestBase = this;
        synchronized (hangingServiceRequestBase) {
            this.response = this.validateAndEmitRequest();
            this.internalOnConnect();
        }
    }

    /*
     * Exception decompiling
     */
    private void parseResponses() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private void setIsConnected(boolean value) {
        this.isConnected = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        HangingServiceRequestBase hangingServiceRequestBase = this;
        synchronized (hangingServiceRequestBase) {
            IOUtils.closeQuietly((Closeable)this.response);
            this.disconnect(HangingRequestDisconnectReason.UserInitiated, null);
        }
    }

    public void disconnect(HangingRequestDisconnectReason reason, Exception exception) {
        if (this.isConnected()) {
            IOUtils.closeQuietly((Closeable)this.response);
            this.internalOnDisconnect(reason, exception);
        }
    }

    private void internalOnConnect() throws XMLStreamException, IOException, EWSHttpException {
        if (!this.isConnected()) {
            this.isConnected = true;
            if (this.getService().isTraceEnabledFor(TraceFlags.EwsResponseHttpHeaders)) {
                this.getService().processHttpResponseHeaders(TraceFlags.EwsResponseHttpHeaders, this.response);
            }
            int poolSize = 1;
            int maxPoolSize = 1;
            long keepAliveTime = 10L;
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(1);
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(poolSize, maxPoolSize, keepAliveTime, TimeUnit.SECONDS, queue);
            threadPool.execute(new Runnable(){

                public void run() {
                    HangingServiceRequestBase.this.parseResponses();
                }
            });
            threadPool.shutdown();
        }
    }

    private void internalOnDisconnect(HangingRequestDisconnectReason reason, Exception exception) {
        if (this.isConnected()) {
            this.isConnected = false;
            for (IHangingRequestDisconnectHandler disconnect : this.onDisconnectList) {
                disconnect.hangingRequestDisconnectHandler(this, new HangingRequestDisconnectEventArgs(reason, exception));
            }
        }
    }

    @Override
    protected void readPreamble(EwsServiceXmlReader ewsXmlReader) throws Exception {
        try {
            ewsXmlReader.read(new XmlNodeType(7));
        }
        catch (XmlException ex) {
            throw new ServiceRequestException("The response received from the service didn't contain valid XML.", ex);
        }
        catch (ServiceXmlDeserializationException ex) {
            throw new ServiceRequestException("The response received from the service didn't contain valid XML.", ex);
        }
    }

    public static interface IHangingRequestDisconnectHandler {
        public void hangingRequestDisconnectHandler(Object var1, HangingRequestDisconnectEventArgs var2);
    }

    public static interface IHandleResponseObject {
        public void handleResponseObject(Object var1) throws ArgumentException;
    }
}

