/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ICustomXmlUpdateSerializer;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ComplexPropertyCollection<TComplexProperty extends ComplexProperty>
extends ComplexProperty
implements ICustomXmlUpdateSerializer,
Iterable<TComplexProperty>,
IComplexPropertyChangedDelegate<TComplexProperty> {
    private final List<TComplexProperty> items = new ArrayList<TComplexProperty>();
    private final List<TComplexProperty> addedItems = new ArrayList<TComplexProperty>();
    private final List<TComplexProperty> modifiedItems = new ArrayList<TComplexProperty>();
    private final List<TComplexProperty> removedItems = new ArrayList<TComplexProperty>();

    protected abstract TComplexProperty createComplexProperty(String var1);

    protected abstract String getCollectionItemXmlElementName(TComplexProperty var1);

    protected ComplexPropertyCollection() {
    }

    protected void itemChanged(TComplexProperty property) {
        EwsUtilities.ewsAssert(property != null, "ComplexPropertyCollection.ItemChanged", "The complexProperty argument must be not null");
        if (!this.addedItems.contains(property) && !this.modifiedItems.contains(property)) {
            this.modifiedItems.add(property);
            this.changed();
        }
    }

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        this.loadFromXml(reader, XmlNamespace.Types, localElementName);
    }

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String localElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, localElementName);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                TComplexProperty complexProperty = this.createComplexProperty(reader.getLocalName());
                if (complexProperty != null) {
                    ((ComplexProperty)complexProperty).loadFromXml(reader, reader.getLocalName());
                    this.internalAdd(complexProperty, true);
                    continue;
                }
                reader.skipCurrentElement();
            } while (!reader.isEndElement(xmlNamespace, localElementName));
        } else {
            reader.read();
        }
    }

    @Override
    public void updateFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, xmlElementName);
        if (!reader.isEmptyElement()) {
            int index = 0;
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                TComplexProperty complexProperty = this.createComplexProperty(reader.getLocalName());
                TComplexProperty actualComplexProperty = this.getPropertyAtIndex(index++);
                if (complexProperty == null || !complexProperty.equals(actualComplexProperty)) {
                    throw new ServiceLocalException("Property type incompatible when updating collection.");
                }
                ((ComplexProperty)actualComplexProperty).updateFromXml(reader, xmlNamespace, reader.getLocalName());
            } while (!reader.isEndElement(xmlNamespace, xmlElementName));
        }
    }

    @Override
    public void writeToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        if (this.shouldWriteToXml()) {
            super.writeToXml(writer, xmlNamespace, xmlElementName);
        }
    }

    public boolean shouldWriteToXml() {
        return this.getCount() > 0;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        for (ComplexProperty complexProperty : this) {
            complexProperty.writeToXml(writer, this.getCollectionItemXmlElementName(complexProperty));
        }
    }

    @Override
    public void clearChangeLog() {
        this.removedItems.clear();
        this.addedItems.clear();
        this.modifiedItems.clear();
    }

    protected void removeFromChangeLog(TComplexProperty complexProperty) {
        this.removedItems.remove(complexProperty);
        this.modifiedItems.remove(complexProperty);
        this.addedItems.remove(complexProperty);
    }

    public List<TComplexProperty> getItems() {
        return this.items;
    }

    protected List<TComplexProperty> getAddedItems() {
        return this.addedItems;
    }

    protected List<TComplexProperty> getModifiedItems() {
        return this.modifiedItems;
    }

    protected List<TComplexProperty> getRemovedItems() {
        return this.removedItems;
    }

    protected void internalAdd(TComplexProperty complexProperty) {
        this.internalAdd(complexProperty, false);
    }

    private void internalAdd(TComplexProperty complexProperty, boolean loading) {
        EwsUtilities.ewsAssert(complexProperty != null, "ComplexPropertyCollection.InternalAdd", "complexProperty is null");
        if (!this.items.contains(complexProperty)) {
            this.items.add(complexProperty);
            if (!loading) {
                this.removedItems.remove(complexProperty);
                this.addedItems.add(complexProperty);
            }
            ((ComplexProperty)complexProperty).addOnChangeEvent(this);
            this.changed();
        }
    }

    @Override
    public void complexPropertyChanged(TComplexProperty complexProperty) {
        this.itemChanged(complexProperty);
    }

    protected void internalClear() {
        while (this.getCount() > 0) {
            this.internalRemoveAt(0);
        }
    }

    protected void internalRemoveAt(int index) {
        EwsUtilities.ewsAssert(index >= 0 && index < this.getCount(), "ComplexPropertyCollection.InternalRemoveAt", "index is out of range.");
        this.internalRemove((ComplexProperty)this.items.get(index));
    }

    protected boolean internalRemove(TComplexProperty complexProperty) {
        EwsUtilities.ewsAssert(complexProperty != null, "ComplexPropertyCollection.InternalRemove", "complexProperty is null");
        if (this.items.remove(complexProperty)) {
            ((ComplexProperty)complexProperty).removeChangeEvent(this);
            if (!this.addedItems.contains(complexProperty)) {
                this.removedItems.add(complexProperty);
            } else {
                this.addedItems.remove(complexProperty);
            }
            this.modifiedItems.remove(complexProperty);
            this.changed();
            return true;
        }
        return false;
    }

    public boolean contains(TComplexProperty complexProperty) {
        return this.items.contains(complexProperty);
    }

    public int indexOf(TComplexProperty complexProperty) {
        return this.items.indexOf(complexProperty);
    }

    public int getCount() {
        return this.items.size();
    }

    public TComplexProperty getPropertyAtIndex(int index) throws IllegalArgumentException {
        if (index < 0 || index >= this.getCount()) {
            throw new IllegalArgumentException(String.format("index %d is out of range [0..%d[.", index, this.getCount()));
        }
        return (TComplexProperty)((ComplexProperty)this.items.get(index));
    }

    @Override
    public Iterator<TComplexProperty> iterator() {
        return this.items.iterator();
    }

    @Override
    public boolean writeSetUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject, PropertyDefinition propertyDefinition) throws Exception {
        if (this.getCount() == 0) {
            writer.writeStartElement(XmlNamespace.Types, ewsObject.getDeleteFieldXmlElementName());
            propertyDefinition.writeToXml(writer);
            writer.writeEndElement();
            return true;
        }
        return false;
    }

    @Override
    public boolean writeDeleteUpdateToXml(EwsServiceXmlWriter writer, ServiceObject ewsObject) throws Exception {
        return false;
    }
}

