/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.MailboxType;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.ISearchStringProvider;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailAddress
extends ComplexProperty
implements ISearchStringProvider {
    private static final Log LOG = LogFactory.getLog(EmailAddress.class);
    protected static final String SmtpRoutingType = "SMTP";
    private String name;
    private String address;
    private String routingType;
    private MailboxType mailboxType;
    private ItemId id;

    public EmailAddress() {
    }

    public EmailAddress(String smtpAddress) {
        this();
        this.address = smtpAddress;
    }

    public EmailAddress(String name, String smtpAddress) {
        this(smtpAddress);
        this.name = name;
    }

    public EmailAddress(String name, String address, String routingType) {
        this(name, address);
        this.routingType = routingType;
    }

    protected EmailAddress(String name, String address, String routingType, MailboxType mailboxType) {
        this(name, address, routingType);
        this.mailboxType = mailboxType;
    }

    protected EmailAddress(String name, String address, String routingType, MailboxType mailboxType, ItemId id) {
        this(name, address, routingType);
        this.mailboxType = mailboxType;
        this.id = id;
    }

    protected EmailAddress(EmailAddress mailbox) throws Exception {
        this();
        EwsUtilities.validateParam(mailbox, "mailbox");
        this.name = mailbox.getName();
        this.address = mailbox.getAddress();
        this.routingType = mailbox.getRoutingType();
        this.mailboxType = mailbox.getMailboxType();
        this.setId(mailbox.getId());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.canSetFieldValue(this.name, name)) {
            this.name = name;
            this.changed();
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        if (this.canSetFieldValue(this.address, address)) {
            this.address = address;
            this.changed();
        }
    }

    public String getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(String routingType) {
        if (this.canSetFieldValue(this.routingType, routingType)) {
            this.routingType = routingType;
            this.changed();
        }
    }

    public MailboxType getMailboxType() {
        return this.mailboxType;
    }

    public void setMailboxType(MailboxType mailboxType) {
        if (this.canSetFieldValue(this.mailboxType, mailboxType)) {
            this.mailboxType = mailboxType;
            this.changed();
        }
    }

    public ItemId getId() {
        return this.id;
    }

    public void setId(ItemId id) {
        if (this.canSetFieldValue(this.id, id)) {
            this.id = id;
            this.changed();
        }
    }

    public static EmailAddress getEmailAddressFromString(String smtpAddress) {
        return new EmailAddress(smtpAddress);
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        try {
            if (reader.getLocalName().equals("Name")) {
                this.name = reader.readElementValue();
                return true;
            }
            if (reader.getLocalName().equals("EmailAddress")) {
                this.address = reader.readElementValue();
                return true;
            }
            if (reader.getLocalName().equals("RoutingType")) {
                this.routingType = reader.readElementValue();
                return true;
            }
            if (reader.getLocalName().equals("MailboxType")) {
                this.mailboxType = reader.readElementValue(MailboxType.class);
                return true;
            }
            if (reader.getLocalName().equals("ItemId")) {
                this.id = new ItemId();
                this.id.loadFromXml(reader, reader.getLocalName());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return false;
        }
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeElementValue(XmlNamespace.Types, "Name", this.getName());
        writer.writeElementValue(XmlNamespace.Types, "EmailAddress", this.getAddress());
        writer.writeElementValue(XmlNamespace.Types, "RoutingType", this.getRoutingType());
        writer.writeElementValue(XmlNamespace.Types, "MailboxType", (Object)this.getMailboxType());
        if (this.getId() != null) {
            this.getId().writeToXml(writer, "ItemId");
        }
    }

    public String getSearchString() {
        return this.getAddress();
    }

    public String toString() {
        if (null == this.getAddress() || this.getAddress().isEmpty()) {
            return "";
        }
        String addressPart = null != this.getRoutingType() && this.getRoutingType().isEmpty() ? this.getRoutingType() + ":" + this.getAddress() : this.getAddress();
        if (null != this.getName() && !this.getName().isEmpty()) {
            return this.getName() + " <" + addressPart + ">";
        }
        return addressPart;
    }

    protected String getSmtpRoutingType() {
        return SmtpRoutingType;
    }
}

