/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.UserConfigurationDictionaryObjectType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.util.DateTimeUtils;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EditorBrowsable(state=EditorBrowsableState.Never)
public final class UserConfigurationDictionary
extends ComplexProperty
implements Iterable<Object> {
    private Map<Object, Object> dictionary = new HashMap<Object, Object>();
    private boolean isDirty = false;

    public Object getElements(Object key) {
        return this.dictionary.get(key);
    }

    public void setElements(Object key, Object value) throws Exception {
        this.validateEntry(key, value);
        this.dictionary.put(key, value);
        this.changed();
    }

    public void addElement(Object key, Object value) throws Exception {
        this.validateEntry(key, value);
        this.dictionary.put(key, value);
        this.changed();
    }

    public boolean containsKey(Object key) {
        return this.dictionary.containsKey(key);
    }

    public boolean remove(Object key) {
        boolean isRemoved = false;
        if (key != null) {
            this.dictionary.remove(key);
            isRemoved = true;
        }
        if (isRemoved) {
            this.changed();
        }
        return isRemoved;
    }

    public boolean tryGetValue(Object key, OutParam<Object> value) {
        if (this.dictionary.containsKey(key)) {
            value.setParam(this.dictionary.get(key));
            return true;
        }
        value.setParam((Object)null);
        return false;
    }

    public int getCount() {
        return this.dictionary.size();
    }

    public void clear() {
        if (this.dictionary.size() != 0) {
            this.dictionary.clear();
            this.changed();
        }
    }

    public Iterator<Object> getEnumerator() {
        return this.dictionary.values().iterator();
    }

    public boolean getIsDirty() {
        return this.isDirty;
    }

    public void setIsDirty(boolean value) {
        this.isDirty = value;
    }

    @Override
    public void changed() {
        super.changed();
        this.isDirty = true;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.ewsAssert(writer != null, "UserConfigurationDictionary.WriteElementsToXml", "writer is null");
        for (Map.Entry<Object, Object> dictionaryEntry : this.dictionary.entrySet()) {
            writer.writeStartElement(XmlNamespace.Types, "DictionaryEntry");
            this.writeObjectToXml(writer, "DictionaryKey", dictionaryEntry.getKey());
            this.writeObjectToXml(writer, "DictionaryValue", dictionaryEntry.getValue());
            writer.writeEndElement();
        }
    }

    private void writeObjectToXml(EwsServiceXmlWriter writer, String xmlElementName, Object dictionaryObject) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.ewsAssert(writer != null, "UserConfigurationDictionary.WriteObjectToXml", "writer is null");
        EwsUtilities.ewsAssert(xmlElementName != null, "UserConfigurationDictionary.WriteObjectToXml", "xmlElementName is null");
        writer.writeStartElement(XmlNamespace.Types, xmlElementName);
        if (dictionaryObject == null) {
            EwsUtilities.ewsAssert(!xmlElementName.equals("DictionaryKey"), "UserConfigurationDictionary.WriteObjectToXml", "Key is null");
            writer.writeAttributeValue("xsi", "nil", (Object)"true");
        } else {
            this.writeObjectValueToXml(writer, dictionaryObject);
        }
        writer.writeEndElement();
    }

    private void writeObjectValueToXml(EwsServiceXmlWriter writer, Object dictionaryObject) throws XMLStreamException, ServiceXmlSerializationException {
        if (dictionaryObject == null) {
            throw new NullPointerException("DictionaryObject must not be null");
        }
        if (writer == null) {
            throw new NullPointerException("EwsServiceXmlWriter must not be null");
        }
        if (dictionaryObject instanceof String[]) {
            UserConfigurationDictionaryObjectType dictionaryObjectType = UserConfigurationDictionaryObjectType.StringArray;
            this.writeEntryTypeToXml(writer, dictionaryObjectType);
            for (String arrayElement : (String[])dictionaryObject) {
                this.writeEntryValueToXml(writer, arrayElement);
            }
        } else {
            String valueAsString;
            UserConfigurationDictionaryObjectType dictionaryObjectType;
            if (dictionaryObject instanceof String) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.String;
                valueAsString = String.valueOf(dictionaryObject);
            } else if (dictionaryObject instanceof Boolean) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Boolean;
                valueAsString = EwsUtilities.boolToXSBool((Boolean)dictionaryObject);
            } else if (dictionaryObject instanceof Byte) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Byte;
                valueAsString = String.valueOf(dictionaryObject);
            } else if (dictionaryObject instanceof Date) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.DateTime;
                valueAsString = writer.getService().convertDateTimeToUniversalDateTimeString((Date)dictionaryObject);
            } else if (dictionaryObject instanceof Integer) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Integer32;
                valueAsString = String.valueOf(dictionaryObject);
            } else if (dictionaryObject instanceof Long) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.Integer64;
                valueAsString = String.valueOf(dictionaryObject);
            } else if (dictionaryObject instanceof byte[]) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.ByteArray;
                valueAsString = Base64.encodeBase64String((byte[])((byte[])dictionaryObject));
            } else if (dictionaryObject instanceof Byte[]) {
                dictionaryObjectType = UserConfigurationDictionaryObjectType.ByteArray;
                Byte[] from = (Byte[])dictionaryObject;
                byte[] to = new byte[from.length];
                for (int currentIndex = 0; currentIndex < from.length; ++currentIndex) {
                    to[currentIndex] = from[currentIndex];
                }
                valueAsString = Base64.encodeBase64String((byte[])to);
            } else {
                throw new IllegalArgumentException(String.format("Unsupported type: %s", dictionaryObject.getClass().toString()));
            }
            this.writeEntryTypeToXml(writer, dictionaryObjectType);
            this.writeEntryValueToXml(writer, valueAsString);
        }
    }

    private void writeEntryTypeToXml(EwsServiceXmlWriter writer, UserConfigurationDictionaryObjectType dictionaryObjectType) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "Type");
        writer.writeValue(dictionaryObjectType.toString(), "Type");
        writer.writeEndElement();
    }

    private void writeEntryValueToXml(EwsServiceXmlWriter writer, String value) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Types, "Value");
        if (value != null) {
            writer.writeValue(value, "Value");
        }
        writer.writeEndElement();
    }

    @Override
    public void loadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        super.loadFromXml(reader, xmlNamespace, xmlElementName);
        this.isDirty = false;
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.ensureCurrentNodeIsStartElement(this.getNamespace(), "DictionaryEntry");
        this.loadEntry(reader);
        return true;
    }

    private void loadEntry(EwsServiceXmlReader reader) throws Exception {
        boolean hasValue;
        EwsUtilities.ewsAssert(reader != null, "UserConfigurationDictionary.LoadEntry", "reader is null");
        Object value = null;
        reader.readStartElement(this.getNamespace(), "DictionaryKey");
        Object key = this.getDictionaryObject(reader);
        reader.readStartElement(this.getNamespace(), "DictionaryValue");
        String nil = reader.readAttributeValue(XmlNamespace.XmlSchemaInstance, "nil");
        boolean bl = hasValue = nil == null || !nil.getClass().equals(Boolean.TYPE);
        if (hasValue) {
            value = this.getDictionaryObject(reader);
        }
        this.dictionary.put(key, value);
    }

    private Object getDictionaryObject(EwsServiceXmlReader reader) throws Exception {
        EwsUtilities.ewsAssert(reader != null, "UserConfigurationDictionary.loadFromXml", "reader is null");
        UserConfigurationDictionaryObjectType type = this.getObjectType(reader);
        List<String> values = this.getObjectValue(reader, type);
        return this.constructObject(type, values, reader);
    }

    private List<String> getObjectValue(EwsServiceXmlReader reader, UserConfigurationDictionaryObjectType type) throws Exception {
        EwsUtilities.ewsAssert(reader != null, "UserConfigurationDictionary.loadFromXml", "reader is null");
        ArrayList<String> values = new ArrayList<String>();
        reader.readStartElement(this.getNamespace(), "Value");
        do {
            String value = null;
            if (reader.isEmptyElement()) {
                if (type.equals((Object)UserConfigurationDictionaryObjectType.String) || type.equals((Object)UserConfigurationDictionaryObjectType.StringArray)) {
                    value = "";
                } else {
                    EwsUtilities.ewsAssert(false, "UserConfigurationDictionary.GetObjectValue", "Empty element passed for type: " + type.toString());
                }
            } else {
                value = reader.readElementValue();
            }
            values.add(value);
            reader.read();
        } while (reader.isStartElement(this.getNamespace(), "Value"));
        return values;
    }

    private UserConfigurationDictionaryObjectType getObjectType(EwsServiceXmlReader reader) throws Exception {
        EwsUtilities.ewsAssert(reader != null, "UserConfigurationDictionary.loadFromXml", "reader is null");
        reader.readStartElement(this.getNamespace(), "Type");
        String type = reader.readElementValue();
        return UserConfigurationDictionaryObjectType.valueOf(type);
    }

    private Object constructObject(UserConfigurationDictionaryObjectType type, List<String> value, EwsServiceXmlReader reader) {
        EwsUtilities.ewsAssert(value != null, "UserConfigurationDictionary.ConstructObject", "value is null");
        EwsUtilities.ewsAssert(value.size() == 1 || type == UserConfigurationDictionaryObjectType.StringArray, "UserConfigurationDictionary.ConstructObject", "value is array but type is not StringArray");
        EwsUtilities.ewsAssert(reader != null, "UserConfigurationDictionary.ConstructObject", "reader is null");
        Object dictionaryObject = null;
        if (type.equals((Object)UserConfigurationDictionaryObjectType.Boolean)) {
            dictionaryObject = Boolean.parseBoolean(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.Byte)) {
            dictionaryObject = Byte.parseByte(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.ByteArray)) {
            dictionaryObject = Base64.decodeBase64((String)value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.DateTime)) {
            Date dateTime = DateTimeUtils.convertDateTimeStringToDate(value.get(0));
            if (dateTime != null) {
                dictionaryObject = dateTime;
            } else {
                EwsUtilities.ewsAssert(false, "UserConfigurationDictionary.ConstructObject", "DateTime is null");
            }
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.Integer32)) {
            dictionaryObject = Integer.parseInt(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.Integer64)) {
            dictionaryObject = Long.parseLong(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.String)) {
            dictionaryObject = String.valueOf(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.StringArray)) {
            dictionaryObject = value.toArray();
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.UnsignedInteger32)) {
            dictionaryObject = Integer.parseInt(value.get(0));
        } else if (type.equals((Object)UserConfigurationDictionaryObjectType.UnsignedInteger64)) {
            dictionaryObject = Long.parseLong(value.get(0));
        } else {
            EwsUtilities.ewsAssert(false, "UserConfigurationDictionary.ConstructObject", "Type not recognized: " + type.toString());
        }
        return dictionaryObject;
    }

    private void validateEntry(Object key, Object value) throws Exception {
        this.validateObject(key);
        this.validateObject(value);
    }

    private void validateObject(Object dictionaryObject) throws Exception {
        if (dictionaryObject != null) {
            if (dictionaryObject.getClass().isArray()) {
                int length = Array.getLength(dictionaryObject);
                Class<?> wrapperType = Array.get(dictionaryObject, 0).getClass();
                Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
                for (int i = 0; i < length; ++i) {
                    newArray[i] = Array.get(dictionaryObject, i);
                }
                this.validateArrayObject(newArray);
            } else {
                this.validateObjectType(dictionaryObject);
            }
        } else {
            throw new NullPointerException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateArrayObject(Object[] dictionaryObjectAsArray) throws ServiceLocalException {
        if (dictionaryObjectAsArray instanceof String[]) {
            if (dictionaryObjectAsArray.length <= 0) throw new ServiceLocalException("The array must contain at least one element.");
            for (Object arrayElement : dictionaryObjectAsArray) {
                if (arrayElement != null) continue;
                throw new ServiceLocalException("The array contains at least one null element.");
            }
            return;
        } else {
            if (!(dictionaryObjectAsArray instanceof Byte[])) throw new ServiceLocalException(String.format("Objects of type %s can't be added to the dictionary. The following types are supported: string array, byte array, boolean, byte, DateTime, integer, long, string, unsigned integer, and unsigned long.", dictionaryObjectAsArray.getClass()));
            if (dictionaryObjectAsArray.length > 0) return;
            throw new ServiceLocalException("The array must contain at least one element.");
        }
    }

    private void validateObjectType(Object theObject) throws ServiceLocalException {
        boolean isValidType = false;
        if (theObject != null && (theObject instanceof String || theObject instanceof Boolean || theObject instanceof Byte || theObject instanceof Long || theObject instanceof Date || theObject instanceof Integer)) {
            isValidType = true;
        }
        if (!isValidType) {
            throw new ServiceLocalException(String.format("Objects of type %s can't be added to the dictionary. The following types are supported: string array, byte array, boolean, byte, DateTime, integer, long, string, unsigned integer, and unsigned long.", theObject != null ? theObject.getClass().toString() : "null"));
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.dictionary.values().iterator();
    }
}

