/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.recurrence.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeek;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeekIndex;
import microsoft.exchange.webservices.data.core.enumeration.property.time.Month;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.property.complex.recurrence.DayOfTheWeekCollection;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.EndDateRecurrenceRange;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.NoEndRecurrenceRange;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.NumberedRecurrenceRange;
import microsoft.exchange.webservices.data.property.complex.recurrence.range.RecurrenceRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Recurrence
extends ComplexProperty {
    private Date startDate;
    private Integer numberOfOccurrences;
    private Date endDate;

    public Recurrence() {
    }

    public Recurrence(Date startDate) {
        this();
        this.startDate = startDate;
    }

    public abstract String getXmlElementName();

    public boolean isRegenerationPattern() {
        return false;
    }

    public void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
    }

    @Override
    public final void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, this.getXmlElementName());
        this.internalWritePropertiesToXml(writer);
        writer.writeEndElement();
        RecurrenceRange range = null;
        if (!this.hasEnd()) {
            range = new NoEndRecurrenceRange(this.getStartDate());
        } else if (this.getNumberOfOccurrences() != null) {
            range = new NumberedRecurrenceRange(this.startDate, this.numberOfOccurrences);
        } else if (this.getEndDate() != null) {
            range = new EndDateRecurrenceRange(this.getStartDate(), this.getEndDate());
        }
        if (range != null) {
            range.writeToXml(writer, range.getXmlElementName());
        }
    }

    public <T> T getFieldValueOrThrowIfNull(Class<T> cls, Object value, String name) throws ServiceValidationException {
        if (value != null) {
            return (T)value;
        }
        throw new ServiceValidationException(String.format("The recurrence pattern's %s property must be specified.", name));
    }

    public Date getStartDate() throws ServiceValidationException {
        return this.getFieldValueOrThrowIfNull(Date.class, this.startDate, "StartDate");
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public boolean hasEnd() {
        return this.numberOfOccurrences != null || this.endDate != null;
    }

    public void neverEnds() {
        this.numberOfOccurrences = null;
        this.endDate = null;
        this.changed();
    }

    @Override
    public void internalValidate() throws Exception {
        super.internalValidate();
        if (this.startDate == null) {
            throw new ServiceValidationException("The recurrence pattern's StartDate property must be specified.");
        }
    }

    public Integer getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    public void setNumberOfOccurrences(Integer value) throws ArgumentException {
        if (value < 1) {
            throw new ArgumentException("NumberOfOccurrences must be greater than 0.");
        }
        if (this.canSetFieldValue(this.numberOfOccurrences, value)) {
            this.numberOfOccurrences = value;
            this.changed();
        }
        this.endDate = null;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date value) {
        if (this.canSetFieldValue(this.endDate, value)) {
            this.endDate = value;
            this.changed();
        }
        this.numberOfOccurrences = null;
    }

    public static final class YearlyRegenerationPattern
    extends IntervalPattern {
        public String getXmlElementName() {
            return "YearlyRegeneration";
        }

        public boolean isRegenerationPattern() {
            return true;
        }

        public YearlyRegenerationPattern() {
        }

        public YearlyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }
    }

    public static final class YearlyPattern
    extends Recurrence {
        private Month month;
        private Integer dayOfMonth;

        public YearlyPattern() {
        }

        public YearlyPattern(Date startDate, Month month, int dayOfMonth) {
            super(startDate);
            this.month = month;
            this.dayOfMonth = dayOfMonth;
        }

        public String getXmlElementName() {
            return "AbsoluteYearlyRecurrence";
        }

        public void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DayOfMonth", this.getDayOfMonth());
            writer.writeElementValue(XmlNamespace.Types, "Month", (Object)this.getMonth());
        }

        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DayOfMonth")) {
                this.dayOfMonth = reader.readElementValue(Integer.class);
                return true;
            }
            if (reader.getLocalName().equals("Month")) {
                this.month = reader.readElementValue(Month.class);
                return true;
            }
            return false;
        }

        public void internalValidate() throws Exception {
            super.internalValidate();
            if (this.month == null) {
                throw new ServiceValidationException("The recurrence pattern's Month property must be specified.");
            }
            if (this.dayOfMonth == null) {
                throw new ServiceValidationException("The recurrence pattern's DayOfMonth property must be specified.");
            }
        }

        public Month getMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Month.class, (Object)this.month, "Month");
        }

        public void setMonth(Month value) {
            if (this.canSetFieldValue(this.month, value)) {
                this.month = value;
                this.changed();
            }
        }

        public int getDayOfMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Integer.class, this.dayOfMonth, "DayOfMonth");
        }

        public void setDayOfMonth(int value) throws ArgumentOutOfRangeException {
            if (value < 1 || value > 31) {
                throw new ArgumentOutOfRangeException("DayOfMonth", "DayOfMonth must be between 1 and 31.");
            }
            if (this.canSetFieldValue(this.dayOfMonth, value)) {
                this.dayOfMonth = value;
                this.changed();
            }
        }
    }

    public static final class WeeklyRegenerationPattern
    extends IntervalPattern {
        public WeeklyRegenerationPattern() {
        }

        public WeeklyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }

        public String getXmlElementName() {
            return "WeeklyRegeneration";
        }

        public boolean isRegenerationPattern() {
            return true;
        }
    }

    public static final class WeeklyPattern
    extends IntervalPattern
    implements IComplexPropertyChangedDelegate {
        private DayOfTheWeekCollection daysOfTheWeek = new DayOfTheWeekCollection();
        private Calendar firstDayOfWeek;

        public WeeklyPattern() {
            this.daysOfTheWeek.addOnChangeEvent(this);
        }

        public WeeklyPattern(Date startDate, int interval, DayOfTheWeek ... daysOfTheWeek) throws ArgumentOutOfRangeException {
            super(startDate, interval);
            ArrayList<DayOfTheWeek> toProcess = new ArrayList<DayOfTheWeek>(Arrays.asList(daysOfTheWeek));
            Iterator<DayOfTheWeek> idaysOfTheWeek = toProcess.iterator();
            this.daysOfTheWeek.addRange(idaysOfTheWeek);
        }

        private void daysOfTheWeekChanged(ComplexProperty complexProperty) {
            this.changed();
        }

        public String getXmlElementName() {
            return "WeeklyRecurrence";
        }

        public void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            this.getDaysOfTheWeek().writeToXml(writer, "DaysOfWeek");
            if (this.firstDayOfWeek != null) {
                EwsUtilities.validatePropertyVersion((ExchangeService)writer.getService(), ExchangeVersion.Exchange2010_SP1, "FirstDayOfWeek");
                writer.writeElementValue(XmlNamespace.Types, "FirstDayOfWeek", this.firstDayOfWeek);
            }
        }

        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DaysOfWeek")) {
                this.getDaysOfTheWeek().loadFromXml(reader, reader.getLocalName());
                return true;
            }
            if (reader.getLocalName().equals("FirstDayOfWeek")) {
                this.firstDayOfWeek = reader.readElementValue(Calendar.class, XmlNamespace.Types, "FirstDayOfWeek");
                return true;
            }
            return false;
        }

        public void internalValidate() throws Exception {
            super.internalValidate();
            if (this.getDaysOfTheWeek().getCount() == 0) {
                throw new ServiceValidationException("The recurrence pattern's property DaysOfTheWeek must contain at least one day of the week.");
            }
        }

        public DayOfTheWeekCollection getDaysOfTheWeek() {
            return this.daysOfTheWeek;
        }

        public Calendar getFirstDayOfWeek() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Calendar.class, this.firstDayOfWeek, "FirstDayOfWeek");
        }

        public void setFirstDayOfWeek(Calendar value) {
            if (this.canSetFieldValue(this.firstDayOfWeek, value)) {
                this.firstDayOfWeek = value;
                this.changed();
            }
        }

        public void complexPropertyChanged(ComplexProperty complexProperty) {
            this.daysOfTheWeekChanged(complexProperty);
        }
    }

    public static final class RelativeYearlyPattern
    extends Recurrence {
        private DayOfTheWeek dayOfTheWeek;
        private DayOfTheWeekIndex dayOfTheWeekIndex;
        private Month month;

        public String getXmlElementName() {
            return "RelativeYearlyRecurrence";
        }

        public void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DaysOfWeek", (Object)this.dayOfTheWeek);
            writer.writeElementValue(XmlNamespace.Types, "DayOfWeekIndex", (Object)this.dayOfTheWeekIndex);
            writer.writeElementValue(XmlNamespace.Types, "Month", (Object)this.month);
        }

        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DaysOfWeek")) {
                this.dayOfTheWeek = reader.readElementValue(DayOfTheWeek.class);
                return true;
            }
            if (reader.getLocalName().equals("DayOfWeekIndex")) {
                this.dayOfTheWeekIndex = reader.readElementValue(DayOfTheWeekIndex.class);
                return true;
            }
            if (reader.getLocalName().equals("Month")) {
                this.month = reader.readElementValue(Month.class);
                return true;
            }
            return false;
        }

        public RelativeYearlyPattern() {
        }

        public RelativeYearlyPattern(Date startDate, Month month, DayOfTheWeek dayOfTheWeek, DayOfTheWeekIndex dayOfTheWeekIndex) {
            super(startDate);
            this.month = month;
            this.dayOfTheWeek = dayOfTheWeek;
            this.dayOfTheWeekIndex = dayOfTheWeekIndex;
        }

        public void internalValidate() throws Exception {
            super.internalValidate();
            if (this.dayOfTheWeekIndex == null) {
                throw new ServiceValidationException("The recurrence pattern's DayOfWeekIndex property must be specified.");
            }
            if (this.dayOfTheWeek == null) {
                throw new ServiceValidationException("The recurrence pattern's property DayOfTheWeek must be specified.");
            }
            if (this.month == null) {
                throw new ServiceValidationException("The recurrence pattern's Month property must be specified.");
            }
        }

        public DayOfTheWeekIndex getDayOfTheWeekIndex() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeekIndex.class, (Object)this.dayOfTheWeekIndex, "DayOfTheWeekIndex");
        }

        public void setDayOfTheWeekIndex(DayOfTheWeekIndex value) {
            if (this.canSetFieldValue(this.dayOfTheWeekIndex, value)) {
                this.dayOfTheWeekIndex = value;
                this.changed();
            }
        }

        public DayOfTheWeek getDayOfTheWeek() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeek.class, (Object)this.dayOfTheWeek, "DayOfTheWeek");
        }

        public void setDayOfTheWeek(DayOfTheWeek value) {
            if (this.canSetFieldValue(this.dayOfTheWeek, value)) {
                this.dayOfTheWeek = value;
                this.changed();
            }
        }

        public Month getMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Month.class, (Object)this.month, "Month");
        }

        public void setMonth(Month value) {
            if (this.canSetFieldValue(this.month, value)) {
                this.month = value;
                this.changed();
            }
        }
    }

    public static final class RelativeMonthlyPattern
    extends IntervalPattern {
        private DayOfTheWeek dayOfTheWeek;
        private DayOfTheWeekIndex dayOfTheWeekIndex;

        public RelativeMonthlyPattern() {
        }

        public RelativeMonthlyPattern(Date startDate, int interval, DayOfTheWeek dayOfTheWeek, DayOfTheWeekIndex dayOfTheWeekIndex) throws ArgumentOutOfRangeException {
            super(startDate, interval);
            this.setDayOfTheWeek(dayOfTheWeek);
            this.setDayOfTheWeekIndex(dayOfTheWeekIndex);
        }

        public String getXmlElementName() {
            return "RelativeMonthlyRecurrence";
        }

        public void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DaysOfWeek", (Object)this.getDayOfTheWeek());
            writer.writeElementValue(XmlNamespace.Types, "DayOfWeekIndex", (Object)this.getDayOfTheWeekIndex());
        }

        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DaysOfWeek")) {
                this.dayOfTheWeek = reader.readElementValue(DayOfTheWeek.class);
                return true;
            }
            if (reader.getLocalName().equals("DayOfWeekIndex")) {
                this.dayOfTheWeekIndex = reader.readElementValue(DayOfTheWeekIndex.class);
                return true;
            }
            return false;
        }

        public void internalValidate() throws Exception {
            super.internalValidate();
            if (this.dayOfTheWeek == null) {
                throw new ServiceValidationException("The recurrence pattern's property DayOfTheWeek must be specified.");
            }
            if (this.dayOfTheWeekIndex == null) {
                throw new ServiceValidationException("The recurrence pattern's DayOfWeekIndex property must be specified.");
            }
        }

        public DayOfTheWeekIndex getDayOfTheWeekIndex() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeekIndex.class, (Object)this.dayOfTheWeekIndex, "DayOfTheWeekIndex");
        }

        public void setDayOfTheWeekIndex(DayOfTheWeekIndex value) {
            if (this.canSetFieldValue(this.dayOfTheWeekIndex, value)) {
                this.dayOfTheWeekIndex = value;
                this.changed();
            }
        }

        public DayOfTheWeek getDayOfTheWeek() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(DayOfTheWeek.class, (Object)this.dayOfTheWeek, "DayOfTheWeek");
        }

        public void setDayOfTheWeek(DayOfTheWeek value) {
            if (this.canSetFieldValue(this.dayOfTheWeek, value)) {
                this.dayOfTheWeek = value;
                this.changed();
            }
        }
    }

    public static final class MonthlyRegenerationPattern
    extends IntervalPattern {
        public MonthlyRegenerationPattern() {
        }

        public MonthlyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }

        public String getXmlElementName() {
            return "MonthlyRegeneration";
        }

        public boolean isRegenerationPattern() {
            return true;
        }
    }

    public static final class MonthlyPattern
    extends IntervalPattern {
        private Integer dayOfMonth;

        public MonthlyPattern() {
        }

        public MonthlyPattern(Date startDate, int interval, int dayOfMonth) throws ArgumentOutOfRangeException {
            super(startDate, interval);
            this.setDayOfMonth(dayOfMonth);
        }

        public String getXmlElementName() {
            return "AbsoluteMonthlyRecurrence";
        }

        public void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "DayOfMonth", this.getDayOfMonth());
        }

        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("DayOfMonth")) {
                this.dayOfMonth = reader.readElementValue(Integer.class);
                return true;
            }
            return false;
        }

        public void internalValidate() throws Exception {
            super.internalValidate();
            if (this.dayOfMonth == null) {
                throw new ServiceValidationException("DayOfMonth must be between 1 and 31.");
            }
        }

        public int getDayOfMonth() throws ServiceValidationException {
            return this.getFieldValueOrThrowIfNull(Integer.class, this.dayOfMonth, "DayOfMonth");
        }

        public void setDayOfMonth(int value) throws ArgumentOutOfRangeException {
            if (value < 1 || value > 31) {
                throw new ArgumentOutOfRangeException("DayOfMonth", "DayOfMonth must be between 1 and 31.");
            }
            if (this.canSetFieldValue(this.dayOfMonth, value)) {
                this.dayOfMonth = value;
                this.changed();
            }
        }
    }

    @EditorBrowsable(state=EditorBrowsableState.Never)
    public static abstract class IntervalPattern
    extends Recurrence {
        private int interval = 1;

        public IntervalPattern() {
        }

        public IntervalPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate);
            if (interval < 1) {
                throw new ArgumentOutOfRangeException("interval", "The interval must be greater than or equal to 1.");
            }
            this.setInterval(interval);
        }

        public void internalWritePropertiesToXml(EwsServiceXmlWriter writer) throws Exception {
            super.internalWritePropertiesToXml(writer);
            writer.writeElementValue(XmlNamespace.Types, "Interval", this.getInterval());
        }

        public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
            if (super.tryReadElementFromXml(reader)) {
                return true;
            }
            if (reader.getLocalName().equals("Interval")) {
                this.interval = reader.readElementValue(Integer.class);
                return true;
            }
            return false;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setInterval(int value) throws ArgumentOutOfRangeException {
            if (value < 1) {
                throw new ArgumentOutOfRangeException("value", "The interval must be greater than or equal to 1.");
            }
            if (this.canSetFieldValue(this.interval, value)) {
                this.interval = value;
                this.changed();
            }
        }
    }

    public static final class DailyRegenerationPattern
    extends IntervalPattern {
        public DailyRegenerationPattern() {
        }

        public DailyRegenerationPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }

        public String getXmlElementName() {
            return "DailyRegeneration";
        }

        public boolean isRegenerationPattern() {
            return true;
        }
    }

    public static final class DailyPattern
    extends IntervalPattern {
        public String getXmlElementName() {
            return "DailyRecurrence";
        }

        public DailyPattern() {
        }

        public DailyPattern(Date startDate, int interval) throws ArgumentOutOfRangeException {
            super(startDate, interval);
        }
    }
}

