/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.search.SortDirection;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderByCollection
implements Iterable<Map<PropertyDefinitionBase, SortDirection>> {
    private List<Map<PropertyDefinitionBase, SortDirection>> propDefSortOrderPairList = new ArrayList<Map<PropertyDefinitionBase, SortDirection>>();

    protected OrderByCollection() {
    }

    public void add(PropertyDefinitionBase propertyDefinition, SortDirection sortDirection) throws ServiceLocalException {
        if (this.contains(propertyDefinition)) {
            throw new ServiceLocalException(String.format("Property %s already exists in OrderByCollection.", propertyDefinition.getPrintableName()));
        }
        HashMap<PropertyDefinitionBase, SortDirection> propertyDefinitionSortDirectionPair = new HashMap<PropertyDefinitionBase, SortDirection>();
        propertyDefinitionSortDirectionPair.put(propertyDefinition, sortDirection);
        this.propDefSortOrderPairList.add(propertyDefinitionSortDirectionPair);
    }

    public void clear() {
        this.propDefSortOrderPairList.clear();
    }

    protected boolean contains(PropertyDefinitionBase propertyDefinition) {
        Iterator<Map<PropertyDefinitionBase, SortDirection>> iterator = this.propDefSortOrderPairList.iterator();
        if (iterator.hasNext()) {
            Map<PropertyDefinitionBase, SortDirection> propDefSortOrderPair = iterator.next();
            return propDefSortOrderPair.containsKey(propertyDefinition);
        }
        return false;
    }

    public int count() {
        return this.propDefSortOrderPairList.size();
    }

    public boolean remove(PropertyDefinitionBase propertyDefinition) {
        ArrayList<Map<PropertyDefinitionBase, SortDirection>> removeList = new ArrayList<Map<PropertyDefinitionBase, SortDirection>>();
        for (Map<PropertyDefinitionBase, SortDirection> propDefSortOrderPair : this.propDefSortOrderPairList) {
            if (!propDefSortOrderPair.containsKey(propertyDefinition)) continue;
            removeList.add(propDefSortOrderPair);
        }
        this.propDefSortOrderPairList.removeAll(removeList);
        return removeList.size() > 0;
    }

    public void removeAt(int index) {
        this.propDefSortOrderPairList.remove(index);
    }

    public boolean tryGetValue(PropertyDefinitionBase propertyDefinition, OutParam<SortDirection> sortDirection) {
        for (Map<PropertyDefinitionBase, SortDirection> pair : this.propDefSortOrderPairList) {
            if (!pair.containsKey(propertyDefinition)) continue;
            sortDirection.setParam((Object)pair.get(propertyDefinition));
            return true;
        }
        sortDirection.setParam((Object)SortDirection.Ascending);
        return false;
    }

    protected void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        if (this.count() > 0) {
            writer.writeStartElement(XmlNamespace.Messages, xmlElementName);
            for (Map<PropertyDefinitionBase, SortDirection> keyValuePair : this.propDefSortOrderPairList) {
                writer.writeStartElement(XmlNamespace.Types, "FieldOrder");
                writer.writeAttributeValue("Order", (Object)keyValuePair.values().iterator().next());
                keyValuePair.keySet().iterator().next().writeToXml(writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    @Override
    public Iterator<Map<PropertyDefinitionBase, SortDirection>> iterator() {
        return this.propDefSortOrderPairList.iterator();
    }

    public Map<PropertyDefinitionBase, SortDirection> getPropertyDefinitionSortDirectionPair(int index) {
        return this.propDefSortOrderPairList.get(index);
    }

    public Iterator<Map<PropertyDefinitionBase, SortDirection>> getEnumerator() {
        return this.propDefSortOrderPairList.iterator();
    }
}

